/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.Value;

public class StackTrackerEntry {
    private final int bci;
    private final String type;
    private final int slot;
    private boolean isValid;
    private Value value;

    public StackTrackerEntry(int bci, String type, int slot) {
        this.bci = bci;
        this.type = type;
        this.slot = slot;
    }

    int getTypeTag() {
        return this.type.charAt(0);
    }

    public String getType() {
        return this.type;
    }

    public int getBci() {
        return this.bci;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Value getValue() {
        assert (this.isValid);
        return this.value;
    }

    void setValue(Value value) {
        assert (!this.isValid);
        this.isValid = true;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StackTrackerEntry) {
            StackTrackerEntry other = (StackTrackerEntry)obj;
            return this.bci == other.bci && this.slot == other.slot;
        }
        return false;
    }

    public int hashCode() {
        return this.bci * 31 ^ this.slot;
    }
}

