/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.ArrayReference;
import com.sap.jvm.jdi.CharValue;
import com.sap.jvm.jdi.Field;
import com.sap.jvm.jdi.IntegerValue;
import com.sap.jvm.jdi.StringReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;

public class StringReferenceImpl
extends ObjectReferenceImpl
implements StringReference {
    private String value;
    private int len = -1;

    StringReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    public String value() {
        return this.valueImpl();
    }

    private String valueImpl() {
        if (this.value == null) {
            try {
                this.value = JDWP.StringReference.Value.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this).stringValue;
                this.len = this.value.length();
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.value;
    }

    @Override
    public String toString() {
        return "\"" + this.value() + "\"";
    }

    @Override
    byte typeValueKey() {
        return 115;
    }

    @Override
    public int getLength() {
        Value v;
        if (this.len >= 0) {
            return this.len;
        }
        if (this.virtualMachine().canUseStringExtensions()) {
            try {
                this.len = JDWP.SapExtensions.GetStringLength.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this).length;
                return this.len;
            }
            catch (JDWPException jDWPException) {
                // empty catch block
            }
        }
        for (Field f : this.referenceType().allFields()) {
            if (!f.name().equals("count") || !f.signature().equals("I") || !((v = this.getValue(f)) instanceof IntegerValue)) continue;
            this.len = ((IntegerValue)v).intValue();
            return this.len;
        }
        for (Field f : this.referenceType().allFields()) {
            if (!f.name().equals("value") || !f.signature().equals("[C") || !((v = this.getValue(f)) instanceof ArrayReference)) continue;
            this.len = ((ArrayReference)v).length();
            return this.len;
        }
        this.valueImpl();
        return this.len;
    }

    @Override
    public String substring(int start, int end) {
        if (this.value != null) {
            return this.value.substring(start, end);
        }
        int smallDiff = 100;
        if (this.len != -1 && this.len - (end - start) <= smallDiff) {
            this.valueImpl();
            if (this.value != null) {
                return this.value.substring(start, end);
            }
        }
        if (this.virtualMachine().canUseStringExtensions()) {
            try {
                return JDWP.SapExtensions.GetStringRange.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this, (int)start, (int)(end - start)).value;
            }
            catch (JDWPException jDWPException) {
                // empty catch block
            }
        }
        Field countField = null;
        Field offsetField = null;
        Field valueField = null;
        for (Field f : this.referenceType().allFields()) {
            if (f.name().equals("count") && f.signature().equals("I")) {
                countField = f;
                continue;
            }
            if (f.name().equals("value") && f.signature().equals("[C")) {
                valueField = f;
                continue;
            }
            if (!f.name().equals("offset") || !f.signature().equals("I")) continue;
            offsetField = f;
        }
        if (valueField != null) {
            int count;
            int offset;
            ArrayReference value = (ArrayReference)this.getValue(valueField);
            if (offsetField != null && countField != null) {
                offset = ((IntegerValue)this.getValue(offsetField)).intValue();
                count = ((IntegerValue)this.getValue(countField)).intValue();
            } else {
                offset = 0;
                count = value.length();
            }
            if (this.len == -1) {
                this.len = count;
            }
            StringBuilder result = new StringBuilder(end - start);
            for (Value ch : value.getValues(start + offset, end - start)) {
                result.append(((CharValue)ch).charValue());
            }
            return result.toString();
        }
        this.valueImpl();
        return this.value.substring(start, end);
    }
}

