/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.VMDisconnectedException;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.connect.spi.Connection;
import com.sap.jvm.jdi.event.EventQueue;
import com.sap.jvm.jdi.event.EventSet;
import com.sap.jvm.tools.jdi.EventQueueImpl;
import com.sap.jvm.tools.jdi.EventSetImpl;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.Packet;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TargetVM
implements Runnable {
    private Map<String, Packet> waitingQueue = new HashMap<String, Packet>(32, 0.75f);
    private boolean shouldListen = true;
    private List<EventQueue> eventQueues = Collections.synchronizedList(new ArrayList(2));
    private VirtualMachineImpl vm;
    private Connection connection;
    private Thread readerThread;
    private EventController eventController = null;
    private boolean eventsHeld = false;
    private static final int OVERLOADED_QUEUE = 2000;
    private static final int UNDERLOADED_QUEUE = 100;

    TargetVM(VirtualMachineImpl vm, Connection connection) {
        this.vm = vm;
        this.connection = connection;
        this.readerThread = new Thread(vm.threadGroupForJDI(), this, "JDI Target VM Interface");
        this.readerThread.setDaemon(true);
    }

    void start() {
        this.readerThread.start();
    }

    private void dumpPacket(Packet packet, boolean sending) {
        String direction;
        String string = direction = sending ? "Sending" : "Receiving";
        if (sending) {
            this.vm.printTrace(direction + " Command. id=" + packet.id + ", length=" + packet.data.length + ", commandSet=" + packet.cmdSet + ", command=" + packet.cmd + ", flags=" + packet.flags);
        } else {
            String type = (packet.flags & 0x80) != 0 ? "Reply" : "Event";
            this.vm.printTrace(direction + " " + type + ". id=" + packet.id + ", length=" + packet.data.length + ", errorCode=" + packet.errorCode + ", flags=" + packet.flags);
        }
        StringBuilder line = new StringBuilder(80);
        line.append("0000: ");
        for (int i = 0; i < packet.data.length; ++i) {
            int val;
            String str;
            if (i > 0 && i % 16 == 0) {
                this.vm.printTrace(line.toString());
                line.setLength(0);
                line.append(String.valueOf(i));
                line.append(": ");
                int len = line.length();
                for (int j = 0; j < 6 - len; ++j) {
                    line.insert(0, '0');
                }
            }
            if ((str = Integer.toHexString(val = 0xFF & packet.data[i])).length() == 1) {
                line.append('0');
            }
            line.append(str);
            line.append(' ');
        }
        if (line.length() > 6) {
            this.vm.printTrace(line.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Iterator<Object> iter;
        if ((this.vm.traceFlags & 1) != 0) {
            this.vm.printTrace("Target VM interface thread running");
        }
        Packet p = null;
        while (this.shouldListen) {
            Packet p2;
            boolean done = false;
            try {
                byte[] b = this.connection.readPacket();
                if (b.length == 0) {
                    done = true;
                }
                p = Packet.fromByteArray(b);
            }
            catch (IOException e) {
                done = true;
            }
            if (done) {
                this.shouldListen = false;
                try {
                    this.connection.close();
                }
                catch (IOException e) {}
                break;
            }
            if ((this.vm.traceFlags & VirtualMachineImpl.TRACE_RAW_RECEIVES) != 0) {
                this.dumpPacket(p, false);
            }
            if ((p.flags & 0x80) == 0) {
                this.handleVMCommand(p);
                continue;
            }
            this.vm.state().notifyCommandComplete(p.id);
            String idString = String.valueOf(p.id);
            Object e = this.waitingQueue;
            synchronized (e) {
                p2 = this.waitingQueue.get(idString);
                if (p2 != null) {
                    this.waitingQueue.remove(idString);
                }
            }
            if (p2 == null) {
                System.err.println("Recieved reply with no sender!");
                continue;
            }
            p2.errorCode = p.errorCode;
            p2.data = p.data;
            p2.replied = true;
            e = p2;
            synchronized (e) {
                p2.notify();
            }
        }
        this.vm.vmManager.disposeVirtualMachine(this.vm);
        Object object = this.eventQueues;
        synchronized (object) {
            iter = this.eventQueues.iterator();
            while (iter.hasNext()) {
                ((EventQueueImpl)iter.next()).close();
            }
        }
        object = this.waitingQueue;
        synchronized (object) {
            iter = this.waitingQueue.values().iterator();
            while (iter.hasNext()) {
                Packet packet;
                Packet packet2 = packet = (Packet)iter.next();
                synchronized (packet2) {
                    packet.notify();
                }
            }
            this.waitingQueue.clear();
        }
        if ((this.vm.traceFlags & 1) != 0) {
            this.vm.printTrace("Target VM interface thread exiting");
        }
    }

    protected void handleVMCommand(Packet p) {
        switch (p.cmdSet) {
            case 64: {
                this.handleEventCmdSet(p);
                break;
            }
            default: {
                System.err.println("Ignoring cmd " + p.id + "/" + p.cmdSet + "/" + p.cmd + " from the VM");
                return;
            }
        }
    }

    protected void handleEventCmdSet(Packet p) {
        EventSetImpl eventSet = new EventSetImpl((VirtualMachine)this.vm, p);
        this.queueEventSet(eventSet);
    }

    private EventController eventController() {
        if (this.eventController == null) {
            this.eventController = new EventController(this.vm);
        }
        return this.eventController;
    }

    private synchronized void controlEventFlow(int maxQueueSize) {
        if (!this.eventsHeld && maxQueueSize > 2000) {
            this.eventController().hold();
            this.eventsHeld = true;
        } else if (this.eventsHeld && maxQueueSize < 100) {
            this.eventController().release();
            this.eventsHeld = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDequeueEventSet() {
        int maxQueueSize = 0;
        List<EventQueue> list = this.eventQueues;
        synchronized (list) {
            for (EventQueueImpl eventQueueImpl : this.eventQueues) {
                maxQueueSize = Math.max(maxQueueSize, eventQueueImpl.size());
            }
        }
        this.controlEventFlow(maxQueueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEventSet(EventSet eventSet) {
        int maxQueueSize = 0;
        List<EventQueue> list = this.eventQueues;
        synchronized (list) {
            for (EventQueueImpl eventQueueImpl : this.eventQueues) {
                eventQueueImpl.enqueue(eventSet);
                maxQueueSize = Math.max(maxQueueSize, eventQueueImpl.size());
            }
        }
        this.controlEventFlow(maxQueueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Packet packet) {
        String id = String.valueOf(packet.id);
        Map<String, Packet> map = this.waitingQueue;
        synchronized (map) {
            this.waitingQueue.put(id, packet);
        }
        if ((this.vm.traceFlags & VirtualMachineImpl.TRACE_RAW_SENDS) != 0) {
            this.dumpPacket(packet, true);
        }
        try {
            this.connection.writePacket(packet.toByteArray());
        }
        catch (IOException e) {
            throw new VMDisconnectedException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReply(Packet packet) {
        Packet packet2 = packet;
        synchronized (packet2) {
            while (!packet.replied && this.shouldListen) {
                try {
                    packet.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!packet.replied) {
                throw new VMDisconnectedException();
            }
        }
    }

    void addEventQueue(EventQueueImpl queue) {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("New event queue added");
        }
        this.eventQueues.add(queue);
    }

    void stopListening() {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("Target VM i/f closing event queues");
        }
        this.shouldListen = false;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class EventController
    extends Thread {
        VirtualMachineImpl vm;
        int controlRequest = 0;

        EventController(VirtualMachineImpl vm) {
            super(vm.threadGroupForJDI(), "JDI Event Control Thread");
            this.vm = vm;
            this.setDaemon(true);
            this.setPriority(7);
            super.start();
        }

        synchronized void hold() {
            ++this.controlRequest;
            this.notifyAll();
        }

        synchronized void release() {
            --this.controlRequest;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int currentRequest;
                EventController eventController = this;
                synchronized (eventController) {
                    while (this.controlRequest == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    currentRequest = this.controlRequest;
                    this.controlRequest = 0;
                }
                try {
                    if (currentRequest > 0) {
                        JDWP.VirtualMachine.HoldEvents.process(this.vm);
                        continue;
                    }
                    JDWP.VirtualMachine.ReleaseEvents.process(this.vm);
                    continue;
                }
                catch (JDWPException e) {
                    e.toJDIException().printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

