/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.ThreadGroupReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.util.Arrays;
import java.util.List;

public class ThreadGroupReferenceImpl
extends ObjectReferenceImpl
implements ThreadGroupReference {
    String name;
    ThreadGroupReference parent;
    boolean triedParent;

    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ThreadGroupReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
        this.vm.state().addListener(this);
    }

    @Override
    protected String description() {
        return "ThreadGroupReference " + this.uniqueID();
    }

    @Override
    public String name() {
        if (this.name == null) {
            try {
                this.name = JDWP.ThreadGroupReference.Name.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).groupName;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.name;
    }

    @Override
    public ThreadGroupReference parent() {
        if (!this.triedParent) {
            try {
                this.parent = JDWP.ThreadGroupReference.Parent.process((VirtualMachineImpl)this.vm, (ThreadGroupReferenceImpl)this).parentGroup;
                this.triedParent = true;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.parent;
    }

    @Override
    public void suspend() {
        for (ThreadReference thread : this.threads()) {
            thread.suspend();
        }
        for (ThreadGroupReference threadGroup : this.threadGroups()) {
            threadGroup.suspend();
        }
    }

    @Override
    public void resume() {
        for (ThreadReference thread : this.threads()) {
            thread.resume();
        }
        for (ThreadGroupReference threadGroup : this.threadGroups()) {
            threadGroup.resume();
        }
    }

    private JDWP.ThreadGroupReference.Children kids() {
        JDWP.ThreadGroupReference.Children kids = null;
        try {
            Cache local = (Cache)this.getCache();
            if (local != null) {
                kids = local.kids;
            }
            if (kids == null) {
                kids = JDWP.ThreadGroupReference.Children.process(this.vm, this);
                if (local != null) {
                    local.kids = kids;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching children ");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return kids;
    }

    @Override
    public List<ThreadReference> threads() {
        return Arrays.asList((ThreadReference[])this.kids().childThreads);
    }

    @Override
    public List<ThreadGroupReference> threadGroups() {
        return Arrays.asList((ThreadGroupReference[])this.kids().childGroups);
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 103;
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        JDWP.ThreadGroupReference.Children kids = null;

        private Cache() {
        }
    }
}

