/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.IncompatibleThreadStateException;
import com.sap.jvm.jdi.InternalException;
import com.sap.jvm.jdi.InvalidStackFrameException;
import com.sap.jvm.jdi.InvalidTypeException;
import com.sap.jvm.jdi.Location;
import com.sap.jvm.jdi.MonitorInfo;
import com.sap.jvm.jdi.NativeMethodException;
import com.sap.jvm.jdi.ObjectReference;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.StackFrame;
import com.sap.jvm.jdi.ThreadGroupReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Value;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.request.BreakpointRequest;
import com.sap.jvm.tools.jdi.ClassTypeImpl;
import com.sap.jvm.tools.jdi.CommandSender;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.MethodImpl;
import com.sap.jvm.tools.jdi.MonitorInfoImpl;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.PacketStream;
import com.sap.jvm.tools.jdi.StackFrameImpl;
import com.sap.jvm.tools.jdi.StackTracker;
import com.sap.jvm.tools.jdi.StackTrackerEntry;
import com.sap.jvm.tools.jdi.ThreadAction;
import com.sap.jvm.tools.jdi.ThreadListener;
import com.sap.jvm.tools.jdi.VMAction;
import com.sap.jvm.tools.jdi.VMState;
import com.sap.jvm.tools.jdi.ValueImpl;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements ThreadReference {
    static final int SUSPEND_STATUS_SUSPENDED = 1;
    static final int SUSPEND_STATUS_BREAK = 2;
    private int suspendedZombieCount = 0;
    private ThreadGroupReference threadGroup;
    private LocalCache localCache;
    private List<WeakReference<ThreadListener>> listeners = new ArrayList<WeakReference<ThreadListener>>();

    private void resetLocalCache() {
        this.localCache = new LocalCache();
    }

    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ThreadReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
        this.resetLocalCache();
        this.vm.state().addListener(this);
    }

    @Override
    protected String description() {
        return "ThreadReference " + this.uniqueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean vmNotSuspended(VMAction action) {
        if (action.resumingThread() == null) {
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                this.processThreadAction(new ThreadAction(this, 2));
            }
        }
        return super.vmNotSuspended(action);
    }

    @Override
    public String name() {
        String name = null;
        try {
            Cache local = (Cache)this.getCache();
            if (local != null) {
                name = local.name;
            }
            if (name == null) {
                name = JDWP.ThreadReference.Name.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).threadName;
                if (local != null) {
                    local.name = name;
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketStream sendResumingCommand(CommandSender sender) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            return sender.send();
        }
    }

    @Override
    public void suspend() {
        try {
            JDWP.ThreadReference.Suspend.process(this.vm, this);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        PacketStream stream;
        if (this.suspendedZombieCount > 0) {
            --this.suspendedZombieCount;
            return;
        }
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.processThreadAction(new ThreadAction(this, 2));
            stream = JDWP.ThreadReference.Resume.enqueueCommand(this.vm, this);
        }
        try {
            JDWP.ThreadReference.Resume.waitForReply(this.vm, stream);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public int suspendCount() {
        if (this.suspendedZombieCount > 0) {
            return this.suspendedZombieCount;
        }
        try {
            return JDWP.ThreadReference.SuspendCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).suspendCount;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public void stop(ObjectReference throwable) throws InvalidTypeException {
        this.validateMirrorOrNull(throwable);
        List<ReferenceType> list = this.vm.classesByName("java.lang.Throwable");
        ClassTypeImpl throwableClass = (ClassTypeImpl)list.get(0);
        if (throwable == null || !throwableClass.isAssignableFrom(throwable)) {
            throw new InvalidTypeException("Not an instance of Throwable");
        }
        try {
            JDWP.ThreadReference.Stop.process(this.vm, this, (ObjectReferenceImpl)throwable);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public void interrupt() {
        try {
            JDWP.ThreadReference.Interrupt.process(this.vm, this);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    private JDWP.ThreadReference.Status jdwpStatus() {
        LocalCache snapshot = this.localCache;
        JDWP.ThreadReference.Status myStatus = snapshot.status;
        try {
            if (myStatus == null) {
                myStatus = JDWP.ThreadReference.Status.process(this.vm, this);
                if ((myStatus.suspendStatus & 1) != 0) {
                    snapshot.status = myStatus;
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return myStatus;
    }

    @Override
    public int status() {
        return this.jdwpStatus().threadStatus;
    }

    @Override
    public boolean isSuspended() {
        return this.suspendedZombieCount > 0 || (this.jdwpStatus().suspendStatus & 1) != 0;
    }

    @Override
    public boolean isAtBreakpoint() {
        try {
            StackFrame frame = this.frame(0);
            Location location = frame.location();
            List<BreakpointRequest> requests = this.vm.eventRequestManager().breakpointRequests();
            for (BreakpointRequest request : requests) {
                if (!location.equals(request.location())) continue;
                return true;
            }
            return false;
        }
        catch (IndexOutOfBoundsException iobe) {
            return false;
        }
        catch (IncompatibleThreadStateException itse) {
            return false;
        }
    }

    @Override
    public ThreadGroupReference threadGroup() {
        if (this.threadGroup == null) {
            try {
                this.threadGroup = JDWP.ThreadReference.ThreadGroup.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).group;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.threadGroup;
    }

    @Override
    public int frameCount() throws IncompatibleThreadStateException {
        LocalCache snapshot = this.localCache;
        try {
            if (snapshot.frameCount == -1) {
                snapshot.frameCount = JDWP.ThreadReference.FrameCount.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).frameCount;
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot.frameCount;
    }

    @Override
    public List<StackFrame> frames() throws IncompatibleThreadStateException {
        return this.privateFrames(0, -1);
    }

    @Override
    public StackFrame frame(int index) throws IncompatibleThreadStateException {
        List<StackFrame> list = this.privateFrames(index, 1);
        return list.get(0);
    }

    private boolean isSubrange(LocalCache snapshot, int start, int length) {
        if (start < snapshot.framesStart) {
            return false;
        }
        if (length == -1) {
            return snapshot.framesLength == -1;
        }
        if (snapshot.framesLength == -1) {
            if (start + length > snapshot.framesStart + snapshot.frames.size()) {
                throw new IndexOutOfBoundsException();
            }
            return true;
        }
        return start + length <= snapshot.framesStart + snapshot.framesLength;
    }

    @Override
    public List<StackFrame> frames(int start, int length) throws IncompatibleThreadStateException {
        if (length < 0) {
            throw new IndexOutOfBoundsException("length must be greater than or equal to zero");
        }
        return this.privateFrames(start, length);
    }

    private synchronized List<StackFrame> privateFrames(int start, int length) throws IncompatibleThreadStateException {
        LocalCache snapshot = this.localCache;
        try {
            if (snapshot.frames == null || !this.isSubrange(snapshot, start, length)) {
                JDWP.ThreadReference.Frames.Frame[] jdwpFrames = JDWP.ThreadReference.Frames.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this, (int)start, (int)length).frames;
                int count = jdwpFrames.length;
                snapshot.frames = new ArrayList<StackFrame>(count);
                for (int i = 0; i < count; ++i) {
                    if (jdwpFrames[i].location == null) {
                        throw new InternalException("Invalid frame location");
                    }
                    StackFrameImpl frame = new StackFrameImpl(this.vm, this, jdwpFrames[i].frameID, jdwpFrames[i].location);
                    snapshot.frames.add(frame);
                }
                snapshot.framesStart = start;
                snapshot.framesLength = length;
                return Collections.unmodifiableList(snapshot.frames);
            }
            int fromIndex = start - snapshot.framesStart;
            int toIndex = length == -1 ? snapshot.frames.size() - fromIndex : fromIndex + length;
            return Collections.unmodifiableList(snapshot.frames.subList(fromIndex, toIndex));
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public List<ObjectReference> ownedMonitors() throws IncompatibleThreadStateException {
        LocalCache snapshot = this.localCache;
        try {
            if (snapshot.ownedMonitors == null) {
                snapshot.ownedMonitors = Arrays.asList((ObjectReference[])JDWP.ThreadReference.OwnedMonitors.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned);
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching owned monitors (count = " + snapshot.ownedMonitors.size() + ")");
                }
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot.ownedMonitors;
    }

    @Override
    public ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        LocalCache snapshot = this.localCache;
        try {
            if (snapshot.contendedMonitor == null && !snapshot.triedCurrentContended) {
                snapshot.contendedMonitor = JDWP.ThreadReference.CurrentContendedMonitor.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).monitor;
                snapshot.triedCurrentContended = true;
                if (snapshot.contendedMonitor != null && (this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching contended monitor (id = " + snapshot.contendedMonitor.uniqueID() + ")");
                }
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot.contendedMonitor;
    }

    @Override
    public List<MonitorInfo> ownedMonitorsAndFrames() throws IncompatibleThreadStateException {
        LocalCache snapshot = this.localCache;
        try {
            if (snapshot.ownedMonitorsInfo == null) {
                JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.monitor[] minfo = JDWP.ThreadReference.OwnedMonitorsStackDepthInfo.process((VirtualMachineImpl)this.vm, (ThreadReferenceImpl)this).owned;
                snapshot.ownedMonitorsInfo = new ArrayList<MonitorInfo>(minfo.length);
                for (int i = 0; i < minfo.length; ++i) {
                    MonitorInfoImpl mon = new MonitorInfoImpl(this.vm, minfo[i].monitor, this, minfo[i].stack_depth);
                    snapshot.ownedMonitorsInfo.add(mon);
                }
                if ((this.vm.traceFlags & 0x10) != 0) {
                    this.vm.printTrace(this.description() + " temporarily caching owned monitors (count = " + snapshot.ownedMonitorsInfo.size() + ")");
                }
            }
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: {
                    throw new IncompatibleThreadStateException();
                }
            }
            throw exc.toJDIException();
        }
        return snapshot.ownedMonitorsInfo;
    }

    @Override
    public void popFrames(StackFrame frame) throws IncompatibleThreadStateException {
        if (!frame.thread().equals(this)) {
            throw new IllegalArgumentException("frame does not belong to this thread");
        }
        if (!this.vm.canPopFrames()) {
            throw new UnsupportedOperationException("target does not support popping frames");
        }
        ((StackFrameImpl)frame).pop();
    }

    @Override
    public void forceEarlyReturn(Value returnValue) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        StackFrameImpl sf;
        if (!this.vm.canForceEarlyReturn()) {
            throw new UnsupportedOperationException("target does not support the forcing of a method to return early");
        }
        this.validateMirrorOrNull(returnValue);
        try {
            sf = (StackFrameImpl)this.frame(0);
        }
        catch (IndexOutOfBoundsException exc) {
            throw new InvalidStackFrameException("No more frames on the stack");
        }
        sf.validateStackFrame();
        MethodImpl meth = (MethodImpl)sf.location().method();
        ValueImpl convertedValue = ValueImpl.prepareForAssignment(returnValue, meth.getReturnValueContainer());
        try {
            JDWP.ThreadReference.ForceEarlyReturn.process(this.vm, this, convertedValue);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 32: {
                    throw new NativeMethodException();
                }
                case 13: {
                    throw new IncompatibleThreadStateException("Thread not suspended");
                }
                case 15: {
                    throw new IncompatibleThreadStateException("Thread has not started or has finished");
                }
                case 31: {
                    throw new InvalidStackFrameException("No more frames on the stack");
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public String toString() {
        return "instance of " + this.referenceType().name() + "(name='" + this.name() + "', id=" + this.uniqueID() + ")";
    }

    @Override
    byte typeValueKey() {
        return 116;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(ThreadListener listener) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.listeners.add(new WeakReference<ThreadListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(ThreadListener listener) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            Iterator<WeakReference<ThreadListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<ThreadListener> ref = iter.next();
                if (!listener.equals(ref.get())) continue;
                iter.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processThreadAction(ThreadAction action) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            Iterator<WeakReference<ThreadListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<ThreadListener> ref = iter.next();
                ThreadListener listener = (ThreadListener)ref.get();
                if (listener != null) {
                    switch (action.id()) {
                        case 2: {
                            if (listener.threadResumable(action)) break;
                            iter.remove();
                        }
                    }
                    continue;
                }
                iter.remove();
            }
            this.resetLocalCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStackTracker(StackTracker tracker) {
        if (!this.isSuspended() || !this.vm.canUseSapExtensions()) {
            return;
        }
        try {
            PacketStream ps;
            boolean isDisable = tracker.getNrOfEntries() == 0;
            StackFrameImpl frame = isDisable ? null : (StackFrameImpl)this.frame(0);
            MethodImpl method = isDisable ? null : (MethodImpl)frame.location().method();
            long methodId = isDisable ? -1L : method.ref();
            int nrOfFrames = isDisable ? -1 : this.frameCount();
            int nrOfEntries = tracker.getNrOfEntries();
            int[] bcis = new int[nrOfEntries];
            int[] slots = new int[nrOfEntries];
            byte[] typeTags = new byte[nrOfEntries];
            int i = 0;
            for (StackTrackerEntry entry : tracker) {
                bcis[i] = entry.getBci();
                slots[i] = entry.getSlot();
                typeTags[i] = (byte)entry.getTypeTag();
                ++i;
            }
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                if (frame != null) {
                    frame.validateStackFrame();
                }
                ps = JDWP.SapExtensions.SetStackTracker.enqueueCommand(this.vm, this, methodId, nrOfFrames, bcis, slots, typeTags);
            }
            JDWP.SapExtensions.SetStackTracker.waitForReply(this.vm, ps);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 99: {
                    return;
                }
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw exc.toJDIException();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
    }

    @Override
    public StackTracker getStackTracker() {
        if (!this.isSuspended() || !this.vm.canUseSapExtensions()) {
            return null;
        }
        PacketStream ps = JDWP.SapExtensions.GetStackTracker.enqueueCommand(this.vm, this);
        try {
            return JDWP.SapExtensions.GetStackTracker.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).tracker;
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 99: {
                    return null;
                }
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public boolean hasTopNativeFrame() throws IncompatibleThreadStateException {
        return this.frameCount() > 0 && this.frame(0).location().method().isNative();
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        String name = null;

        private Cache() {
        }
    }

    private static class LocalCache {
        JDWP.ThreadReference.Status status = null;
        List<StackFrame> frames = null;
        int framesStart = -1;
        int framesLength = 0;
        int frameCount = -1;
        List<ObjectReference> ownedMonitors = null;
        List<MonitorInfo> ownedMonitorsInfo = null;
        ObjectReference contendedMonitor = null;
        boolean triedCurrentContended = false;

        private LocalCache() {
        }
    }
}

