/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.ThreadGroupReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.tools.jdi.CommandSender;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.PacketStream;
import com.sap.jvm.tools.jdi.VMAction;
import com.sap.jvm.tools.jdi.VMListener;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class VMState {
    private final VirtualMachineImpl vm;
    private final List<WeakReference<VMListener>> listeners = new ArrayList<WeakReference<VMListener>>();
    private boolean notifyingListeners = false;
    private int lastCompletedCommandId = 0;
    private int lastResumeCommandId = 0;
    private Cache cache = null;
    private static final Cache markerCache = new Cache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableCache() {
        VMState vMState = this;
        synchronized (vMState) {
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableCache() {
        VMState vMState = this;
        synchronized (vMState) {
            this.cache = markerCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getCache() {
        VMState vMState = this;
        synchronized (vMState) {
            if (this.cache == markerCache) {
                this.cache = new Cache();
            }
            return this.cache;
        }
    }

    VMState(VirtualMachineImpl vm) {
        this.vm = vm;
    }

    boolean isSuspended() {
        return this.cache != null;
    }

    synchronized void notifyCommandComplete(int id) {
        this.lastCompletedCommandId = id;
    }

    synchronized void freeze() {
        if (this.cache == null && this.lastCompletedCommandId >= this.lastResumeCommandId) {
            this.processVMAction(new VMAction(this.vm, 1));
            this.enableCache();
        }
    }

    synchronized PacketStream thawCommand(CommandSender sender) {
        PacketStream stream = sender.send();
        this.lastResumeCommandId = stream.id();
        this.thaw();
        return stream;
    }

    void thaw() {
        this.thaw(null);
    }

    synchronized void thaw(ThreadReference resumingThread) {
        if (this.cache != null) {
            if ((this.vm.traceFlags & 0x10) != 0) {
                this.vm.printTrace("Clearing VM suspended cache");
            }
            this.disableCache();
        }
        this.processVMAction(new VMAction(this.vm, resumingThread, 2));
    }

    private synchronized void processVMAction(VMAction action) {
        if (!this.notifyingListeners) {
            this.notifyingListeners = true;
            Iterator<WeakReference<VMListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<VMListener> ref = iter.next();
                VMListener listener = (VMListener)ref.get();
                if (listener != null) {
                    boolean keep = true;
                    switch (action.id()) {
                        case 1: {
                            keep = listener.vmSuspended(action);
                            break;
                        }
                        case 2: {
                            keep = listener.vmNotSuspended(action);
                        }
                    }
                    if (keep) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            this.notifyingListeners = false;
        }
    }

    synchronized void addListener(VMListener listener) {
        this.listeners.add(new WeakReference<VMListener>(listener));
    }

    synchronized boolean hasListener(VMListener listener) {
        return this.listeners.contains(listener);
    }

    synchronized void removeListener(VMListener listener) {
        Iterator<WeakReference<VMListener>> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            WeakReference<VMListener> ref = iter.next();
            if (!listener.equals(ref.get())) continue;
            iter.remove();
            break;
        }
    }

    List<ThreadReference> allThreads() {
        List<ThreadReference> threads = null;
        try {
            Cache local = this.getCache();
            if (local != null) {
                threads = local.threads;
            }
            if (threads == null) {
                threads = Arrays.asList((ThreadReference[])JDWP.VirtualMachine.AllThreads.process((VirtualMachineImpl)this.vm).threads);
                if (local != null) {
                    local.threads = threads;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("Caching all threads (count = " + threads.size() + ") while VM suspended");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return threads;
    }

    List<ThreadGroupReference> topLevelThreadGroups() {
        List<ThreadGroupReference> groups = null;
        try {
            Cache local = this.getCache();
            if (local != null) {
                groups = local.groups;
            }
            if (groups == null) {
                groups = Arrays.asList((ThreadGroupReference[])JDWP.VirtualMachine.TopLevelThreadGroups.process((VirtualMachineImpl)this.vm).groups);
                if (local != null) {
                    local.groups = groups;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace("Caching top level thread groups (count = " + groups.size() + ") while VM suspended");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return groups;
    }

    private static class Cache {
        List<ThreadGroupReference> groups = null;
        List<ThreadReference> threads = null;

        private Cache() {
        }
    }
}

