/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.BooleanType;
import com.sap.jvm.jdi.BooleanValue;
import com.sap.jvm.jdi.ByteType;
import com.sap.jvm.jdi.ByteValue;
import com.sap.jvm.jdi.CharType;
import com.sap.jvm.jdi.CharValue;
import com.sap.jvm.jdi.ClassLoaderReference;
import com.sap.jvm.jdi.ClassNotLoadedException;
import com.sap.jvm.jdi.DoubleType;
import com.sap.jvm.jdi.DoubleValue;
import com.sap.jvm.jdi.FloatType;
import com.sap.jvm.jdi.FloatValue;
import com.sap.jvm.jdi.IntegerType;
import com.sap.jvm.jdi.IntegerValue;
import com.sap.jvm.jdi.InternalException;
import com.sap.jvm.jdi.LongType;
import com.sap.jvm.jdi.LongValue;
import com.sap.jvm.jdi.ModuleReference;
import com.sap.jvm.jdi.PathSearchingVirtualMachine;
import com.sap.jvm.jdi.PrimitiveType;
import com.sap.jvm.jdi.ReferenceType;
import com.sap.jvm.jdi.ShortType;
import com.sap.jvm.jdi.ShortValue;
import com.sap.jvm.jdi.StringReference;
import com.sap.jvm.jdi.ThreadGroupReference;
import com.sap.jvm.jdi.ThreadReference;
import com.sap.jvm.jdi.Type;
import com.sap.jvm.jdi.VMDisconnectedException;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.VirtualMachineManager;
import com.sap.jvm.jdi.VoidType;
import com.sap.jvm.jdi.VoidValue;
import com.sap.jvm.jdi.connect.spi.Connection;
import com.sap.jvm.jdi.event.EventQueue;
import com.sap.jvm.jdi.request.BreakpointRequest;
import com.sap.jvm.jdi.request.EventRequest;
import com.sap.jvm.jdi.request.EventRequestManager;
import com.sap.jvm.tools.jdi.ArrayReferenceImpl;
import com.sap.jvm.tools.jdi.ArrayTypeImpl;
import com.sap.jvm.tools.jdi.BooleanTypeImpl;
import com.sap.jvm.tools.jdi.BooleanValueImpl;
import com.sap.jvm.tools.jdi.ByteTypeImpl;
import com.sap.jvm.tools.jdi.ByteValueImpl;
import com.sap.jvm.tools.jdi.CharTypeImpl;
import com.sap.jvm.tools.jdi.CharValueImpl;
import com.sap.jvm.tools.jdi.ClassLoaderReferenceImpl;
import com.sap.jvm.tools.jdi.ClassObjectReferenceImpl;
import com.sap.jvm.tools.jdi.ClassTypeImpl;
import com.sap.jvm.tools.jdi.CommandSender;
import com.sap.jvm.tools.jdi.DoubleTypeImpl;
import com.sap.jvm.tools.jdi.DoubleValueImpl;
import com.sap.jvm.tools.jdi.EventQueueImpl;
import com.sap.jvm.tools.jdi.EventRequestManagerImpl;
import com.sap.jvm.tools.jdi.FloatTypeImpl;
import com.sap.jvm.tools.jdi.FloatValueImpl;
import com.sap.jvm.tools.jdi.IntegerTypeImpl;
import com.sap.jvm.tools.jdi.IntegerValueImpl;
import com.sap.jvm.tools.jdi.InterfaceTypeImpl;
import com.sap.jvm.tools.jdi.InternalEventHandler;
import com.sap.jvm.tools.jdi.JDWP;
import com.sap.jvm.tools.jdi.JDWPException;
import com.sap.jvm.tools.jdi.JNITypeParser;
import com.sap.jvm.tools.jdi.LongTypeImpl;
import com.sap.jvm.tools.jdi.LongValueImpl;
import com.sap.jvm.tools.jdi.MirrorImpl;
import com.sap.jvm.tools.jdi.ModuleReferenceImpl;
import com.sap.jvm.tools.jdi.ObjectReferenceImpl;
import com.sap.jvm.tools.jdi.Packet;
import com.sap.jvm.tools.jdi.PacketStream;
import com.sap.jvm.tools.jdi.ReferenceTypeImpl;
import com.sap.jvm.tools.jdi.ShortTypeImpl;
import com.sap.jvm.tools.jdi.ShortValueImpl;
import com.sap.jvm.tools.jdi.StringReferenceImpl;
import com.sap.jvm.tools.jdi.TargetVM;
import com.sap.jvm.tools.jdi.ThreadAction;
import com.sap.jvm.tools.jdi.ThreadGroupReferenceImpl;
import com.sap.jvm.tools.jdi.ThreadListener;
import com.sap.jvm.tools.jdi.ThreadReferenceImpl;
import com.sap.jvm.tools.jdi.VMState;
import com.sap.jvm.tools.jdi.VirtualMachineManagerImpl;
import com.sap.jvm.tools.jdi.VoidTypeImpl;
import com.sap.jvm.tools.jdi.VoidValueImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class VirtualMachineImpl
extends MirrorImpl
implements PathSearchingVirtualMachine,
ThreadListener {
    public final int sizeofFieldRef;
    public final int sizeofMethodRef;
    public final int sizeofObjectRef;
    public final int sizeofClassRef;
    public final int sizeofFrameRef;
    public final int sizeofModuleRef;
    final int sequenceNumber;
    private final TargetVM target;
    private final EventQueueImpl eventQueue;
    private final EventRequestManagerImpl internalEventRequestManager;
    private final EventRequestManagerImpl eventRequestManager;
    final VirtualMachineManagerImpl vmManager;
    private final ThreadGroup threadGroupForJDI;
    int traceFlags = 0;
    static int TRACE_RAW_SENDS = 0x1000000;
    static int TRACE_RAW_RECEIVES = 0x2000000;
    boolean traceReceives = false;
    private Map<Long, ReferenceType> typesByID;
    private TreeSet<ReferenceType> typesBySignature;
    private boolean retrievedAllTypes = false;
    private Map<Long, ModuleReference> modulesByID;
    private String defaultStratum = null;
    private final Map<Long, SoftObjectReference> objectsByID = new HashMap<Long, SoftObjectReference>();
    private final ReferenceQueue<ObjectReferenceImpl> referenceQueue = new ReferenceQueue();
    private static final int DISPOSE_THRESHOLD = 50;
    private final List<SoftObjectReference> batchedDisposeRequests = Collections.synchronizedList(new ArrayList(60));
    private JDWP.VirtualMachine.Version versionInfo;
    private JDWP.VirtualMachine.ClassPaths pathInfo;
    private JDWP.VirtualMachine.Capabilities capabilities = null;
    private JDWP.VirtualMachine.CapabilitiesNew capabilitiesNew = null;
    private BooleanType theBooleanType;
    private ByteType theByteType;
    private CharType theCharType;
    private ShortType theShortType;
    private IntegerType theIntegerType;
    private LongType theLongType;
    private FloatType theFloatType;
    private DoubleType theDoubleType;
    private VoidType theVoidType;
    private VoidValue voidVal;
    private Process process;
    private int sapExtensionsMajorVersion = -1;
    private int sapExtensionsMinorVersion = -1;
    private boolean hasStackTrackerSupportForAllStepTypes;
    private boolean hasStackTrackerSupportForStepEnd;
    private Object traceContext;
    private VirtualMachine.ConstantPoolMappingCreator constantPoolMappingCreator = null;
    private VMState state = new VMState(this);
    private Object initMonitor = new Object();
    private boolean initComplete = false;
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            this.initComplete = true;
            this.initMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            while (!this.initComplete) {
                try {
                    this.initMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    VMState state() {
        return this.state;
    }

    @Override
    public boolean threadResumable(ThreadAction action) {
        this.state.thaw(action.thread());
        return true;
    }

    VirtualMachineImpl(VirtualMachineManager manager, Connection connection, Process process, int sequenceNumber) {
        super(null);
        JDWP.VirtualMachine.IDSizes idSizes;
        this.vm = this;
        this.vmManager = (VirtualMachineManagerImpl)manager;
        this.process = process;
        this.sequenceNumber = sequenceNumber;
        this.threadGroupForJDI = new ThreadGroup(this.vmManager.mainGroupForJDI(), "JDI [" + this.hashCode() + "]");
        this.target = new TargetVM(this, connection);
        EventQueueImpl internalEventQueue = new EventQueueImpl(this, this.target);
        new InternalEventHandler(this, internalEventQueue);
        this.eventQueue = new EventQueueImpl(this, this.target);
        this.eventRequestManager = new EventRequestManagerImpl(this);
        this.target.start();
        try {
            idSizes = JDWP.VirtualMachine.IDSizes.process(this.vm);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.sizeofFieldRef = idSizes.fieldIDSize;
        this.sizeofMethodRef = idSizes.methodIDSize;
        this.sizeofObjectRef = idSizes.objectIDSize;
        this.sizeofClassRef = idSizes.referenceTypeIDSize;
        this.sizeofFrameRef = idSizes.frameIDSize;
        this.sizeofModuleRef = idSizes.objectIDSize;
        try {
            JDWP.SapExtensions.GetVersion o = JDWP.SapExtensions.GetVersion.process(this.vm);
            this.sapExtensionsMajorVersion = o.major;
            this.sapExtensionsMinorVersion = o.minor;
            this.hasStackTrackerSupportForAllStepTypes = o.allStepsTypes;
            this.hasStackTrackerSupportForStepEnd = o.stackTrackerAtEnd;
        }
        catch (JDWPException o) {
            // empty catch block
        }
        this.internalEventRequestManager = new EventRequestManagerImpl(this);
        EventRequest er = this.internalEventRequestManager.createClassPrepareRequest();
        er.setSuspendPolicy(0);
        er.enable();
        er = this.internalEventRequestManager.createClassUnloadRequest();
        er.setSuspendPolicy(0);
        er.enable();
        this.notifyInitCompletion();
    }

    EventRequestManagerImpl getInternalEventRequestManager() {
        return this.internalEventRequestManager;
    }

    void validateVM() {
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public List<ModuleReference> allModules() {
        this.validateVM();
        List<ModuleReference> modules = this.retrieveAllModules();
        return Collections.unmodifiableList(modules);
    }

    @Override
    public List<ReferenceType> classesByName(String className) {
        this.validateVM();
        String signature = JNITypeParser.typeNameToSignature(className);
        List<ReferenceType> list = this.retrievedAllTypes ? this.findReferenceTypes(signature) : this.retrieveClassesBySignature(signature);
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReferenceType> allClasses() {
        ArrayList<ReferenceType> a;
        this.validateVM();
        if (!this.retrievedAllTypes) {
            this.retrieveAllClasses();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            a = new ArrayList<ReferenceType>(this.typesBySignature);
        }
        return Collections.unmodifiableList(a);
    }

    @Override
    public void redefineClasses(Map<? extends ReferenceType, byte[]> classToBytes) {
        int cnt = classToBytes.size();
        JDWP.VirtualMachine.RedefineClasses.ClassDef[] defs = new JDWP.VirtualMachine.RedefineClasses.ClassDef[cnt];
        this.validateVM();
        if (!this.canRedefineClasses()) {
            throw new UnsupportedOperationException();
        }
        Iterator<Object> it = classToBytes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<? extends ReferenceType, byte[]> entry = it.next();
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)entry.getKey();
            this.validateMirror(referenceTypeImpl);
            defs[i] = new JDWP.VirtualMachine.RedefineClasses.ClassDef(referenceTypeImpl, entry.getValue());
            ++i;
        }
        this.vm.state().thaw();
        try {
            JDWP.VirtualMachine.RedefineClasses.process(this.vm, defs);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 60: {
                    throw new ClassFormatError("class not in class file format");
                }
                case 61: {
                    throw new ClassCircularityError("circularity has been detected while initializing a class");
                }
                case 62: {
                    throw new VerifyError("verifier detected internal inconsistency or security problem");
                }
                case 68: {
                    throw new UnsupportedClassVersionError("version numbers of class are not supported");
                }
                case 63: {
                    throw new UnsupportedOperationException("add method not implemented");
                }
                case 64: {
                    throw new UnsupportedOperationException("schema change not implemented");
                }
                case 66: {
                    throw new UnsupportedOperationException("hierarchy change not implemented");
                }
                case 67: {
                    throw new UnsupportedOperationException("delete method not implemented");
                }
                case 70: {
                    throw new UnsupportedOperationException("changes to class modifiers not implemented");
                }
                case 71: {
                    throw new UnsupportedOperationException("changes to method modifiers not implemented");
                }
                case 69: {
                    throw new NoClassDefFoundError("class names do not match");
                }
            }
            throw exc.toJDIException();
        }
        ArrayList<BreakpointRequest> toDelete = new ArrayList<BreakpointRequest>();
        EventRequestManager erm = this.eventRequestManager();
        for (BreakpointRequest breakpointRequest : erm.breakpointRequests()) {
            if (!classToBytes.containsKey(breakpointRequest.location().declaringType())) continue;
            toDelete.add(breakpointRequest);
        }
        erm.deleteEventRequests(toDelete);
        for (ReferenceTypeImpl referenceTypeImpl : classToBytes.keySet()) {
            referenceTypeImpl.noticeRedefineClass();
        }
    }

    @Override
    public List<ThreadReference> allThreads() {
        this.validateVM();
        return this.state.allThreads();
    }

    @Override
    public List<ThreadGroupReference> topLevelThreadGroups() {
        this.validateVM();
        return this.state.topLevelThreadGroups();
    }

    PacketStream sendResumingCommand(CommandSender sender) {
        return this.state.thawCommand(sender);
    }

    void notifySuspend() {
        this.state.freeze();
    }

    @Override
    public void suspend() {
        this.validateVM();
        try {
            JDWP.VirtualMachine.Suspend.process(this.vm);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.notifySuspend();
    }

    @Override
    public void resume() {
        this.validateVM();
        CommandSender sender = new CommandSender(){

            @Override
            public PacketStream send() {
                return JDWP.VirtualMachine.Resume.enqueueCommand(VirtualMachineImpl.this.vm);
            }
        };
        try {
            PacketStream stream = this.state.thawCommand(sender);
            JDWP.VirtualMachine.Resume.waitForReply(this.vm, stream);
        }
        catch (VMDisconnectedException stream) {
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 112: {
                    return;
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public EventQueue eventQueue() {
        return this.eventQueue;
    }

    @Override
    public EventRequestManager eventRequestManager() {
        this.validateVM();
        return this.eventRequestManager;
    }

    EventRequestManagerImpl eventRequestManagerImpl() {
        return this.eventRequestManager;
    }

    @Override
    public BooleanValue mirrorOf(boolean value) {
        this.validateVM();
        return new BooleanValueImpl(this, value);
    }

    @Override
    public ByteValue mirrorOf(byte value) {
        this.validateVM();
        return new ByteValueImpl(this, value);
    }

    @Override
    public CharValue mirrorOf(char value) {
        this.validateVM();
        return new CharValueImpl(this, value);
    }

    @Override
    public ShortValue mirrorOf(short value) {
        this.validateVM();
        return new ShortValueImpl(this, value);
    }

    @Override
    public IntegerValue mirrorOf(int value) {
        this.validateVM();
        return new IntegerValueImpl(this, value);
    }

    @Override
    public LongValue mirrorOf(long value) {
        this.validateVM();
        return new LongValueImpl(this, value);
    }

    @Override
    public FloatValue mirrorOf(float value) {
        this.validateVM();
        return new FloatValueImpl(this, value);
    }

    @Override
    public DoubleValue mirrorOf(double value) {
        this.validateVM();
        return new DoubleValueImpl(this, value);
    }

    @Override
    public StringReference mirrorOf(String value) {
        this.validateVM();
        try {
            return JDWP.VirtualMachine.CreateString.process((VirtualMachineImpl)this.vm, (String)value).stringObject;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public VoidValue mirrorOfVoid() {
        if (this.voidVal == null) {
            this.voidVal = new VoidValueImpl(this);
        }
        return this.voidVal;
    }

    @Override
    public long[] instanceCounts(List<? extends ReferenceType> classes) {
        long[] retValue;
        if (!this.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        ReferenceTypeImpl[] rtArray = new ReferenceTypeImpl[classes.size()];
        int ii = 0;
        for (ReferenceType referenceType : classes) {
            this.validateMirror(referenceType);
            rtArray[ii++] = (ReferenceTypeImpl)referenceType;
        }
        try {
            retValue = JDWP.VirtualMachine.InstanceCounts.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl[])rtArray).counts;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return retValue;
    }

    @Override
    public void dispose() {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Dispose.process(this.vm);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.target.stopListening();
    }

    @Override
    public void exit(int exitCode) {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Exit.process(this.vm, exitCode);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        this.target.stopListening();
    }

    @Override
    public Process process() {
        this.validateVM();
        return this.process;
    }

    private JDWP.VirtualMachine.Version versionInfo() {
        try {
            if (this.versionInfo == null) {
                this.versionInfo = JDWP.VirtualMachine.Version.process(this.vm);
            }
            return this.versionInfo;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public String description() {
        this.validateVM();
        return MessageFormat.format(this.vmManager.getString("version_format"), "" + this.vmManager.majorInterfaceVersion(), "" + this.vmManager.minorInterfaceVersion(), this.versionInfo().description);
    }

    @Override
    public String version() {
        this.validateVM();
        return this.versionInfo().vmVersion;
    }

    @Override
    public String name() {
        this.validateVM();
        return this.versionInfo().vmName;
    }

    @Override
    public boolean canWatchFieldModification() {
        this.validateVM();
        return this.capabilities().canWatchFieldModification;
    }

    @Override
    public boolean canWatchFieldAccess() {
        this.validateVM();
        return this.capabilities().canWatchFieldAccess;
    }

    @Override
    public boolean canGetBytecodes() {
        this.validateVM();
        return this.capabilities().canGetBytecodes;
    }

    @Override
    public boolean canGetSyntheticAttribute() {
        this.validateVM();
        return this.capabilities().canGetSyntheticAttribute;
    }

    @Override
    public boolean canGetOwnedMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetOwnedMonitorInfo;
    }

    @Override
    public boolean canGetCurrentContendedMonitor() {
        this.validateVM();
        return this.capabilities().canGetCurrentContendedMonitor;
    }

    @Override
    public boolean canGetMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetMonitorInfo;
    }

    private boolean hasNewCapabilities() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 4;
    }

    boolean canGet1_5LanguageFeatures() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 5;
    }

    @Override
    public boolean canUseInstanceFilters() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canUseInstanceFilters;
    }

    @Override
    public boolean canRedefineClasses() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRedefineClasses;
    }

    @Override
    public boolean canAddMethod() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canAddMethod;
    }

    @Override
    public boolean canUnrestrictedlyRedefineClasses() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canUnrestrictedlyRedefineClasses;
    }

    @Override
    public boolean canPopFrames() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canPopFrames;
    }

    @Override
    public boolean canGetMethodReturnValues() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6;
    }

    @Override
    public boolean canGetInstanceInfo() {
        if (this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6) {
            this.validateVM();
            return this.hasNewCapabilities() && this.capabilitiesNew().canGetInstanceInfo;
        }
        return false;
    }

    @Override
    public boolean canUseSourceNameFilters() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6;
    }

    @Override
    public boolean canForceEarlyReturn() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canForceEarlyReturn;
    }

    @Override
    public boolean canBeModified() {
        return true;
    }

    @Override
    public boolean canGetSourceDebugExtension() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canGetSourceDebugExtension;
    }

    @Override
    public boolean canGetClassFileVersion() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 6;
    }

    @Override
    public boolean canGetConstantPool() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canGetConstantPool;
    }

    @Override
    public boolean canRequestVMDeathEvent() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRequestVMDeathEvent;
    }

    @Override
    public boolean canRequestMonitorEvents() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRequestMonitorEvents;
    }

    @Override
    public boolean canGetMonitorFrameInfo() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canGetMonitorFrameInfo;
    }

    @Override
    public boolean canGetModuleInfo() {
        this.validateVM();
        return this.versionInfo().jdwpMajor >= 9;
    }

    @Override
    public void setDebugTraceMode(int traceFlags) {
        this.validateVM();
        this.traceFlags = traceFlags;
        this.traceReceives = (traceFlags & 2) != 0;
    }

    void printTrace(String string) {
        System.err.println("[JDI: " + string + "]");
    }

    void printReceiveTrace(int depth, String string) {
        StringBuilder sb = new StringBuilder("Receiving:");
        for (int i = depth; i > 0; --i) {
            sb.append("    ");
        }
        sb.append(string);
        this.printTrace(sb.toString());
    }

    private synchronized ReferenceTypeImpl addReferenceType(long id, int tag, String signature) {
        if (this.typesByID == null) {
            this.initReferenceTypes();
        }
        ReferenceTypeImpl type = null;
        switch (tag) {
            case 1: {
                type = new ClassTypeImpl(this.vm, id);
                break;
            }
            case 2: {
                type = new InterfaceTypeImpl(this.vm, id);
                break;
            }
            case 3: {
                type = new ArrayTypeImpl(this.vm, id);
                break;
            }
            default: {
                throw new InternalException("Invalid reference type tag");
            }
        }
        if (signature != null) {
            type.setSignature(signature);
        }
        this.typesByID.put(id, type);
        this.typesBySignature.add(type);
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Caching new ReferenceType, sig=" + signature + ", id=" + id);
        }
        return type;
    }

    synchronized void removeReferenceType(String signature) {
        if (this.typesByID == null) {
            return;
        }
        Iterator<ReferenceType> iter = this.typesBySignature.iterator();
        int matches = 0;
        while (iter.hasNext()) {
            ReferenceTypeImpl type = (ReferenceTypeImpl)iter.next();
            int comp = signature.compareTo(type.signature());
            if (comp != 0) continue;
            ++matches;
            iter.remove();
            this.typesByID.remove(type.ref());
            if ((this.vm.traceFlags & 8) == 0) continue;
            this.vm.printTrace("Uncaching ReferenceType, sig=" + signature + ", id=" + type.ref());
        }
        if (matches > 1) {
            this.retrieveClassesBySignature(signature);
        }
    }

    private synchronized List<ReferenceType> findReferenceTypes(String signature) {
        if (this.typesByID == null) {
            return new ArrayList<ReferenceType>(0);
        }
        Iterator<ReferenceType> iter = this.typesBySignature.iterator();
        ArrayList<ReferenceType> list = new ArrayList<ReferenceType>();
        while (iter.hasNext()) {
            ReferenceTypeImpl type = (ReferenceTypeImpl)iter.next();
            int comp = signature.compareTo(type.signature());
            if (comp != 0) continue;
            list.add(type);
        }
        return list;
    }

    private void initReferenceTypes() {
        this.typesByID = new HashMap<Long, ReferenceType>(300);
        this.typesBySignature = new TreeSet();
    }

    ReferenceTypeImpl referenceType(long ref, byte tag) {
        return this.referenceType(ref, tag, null);
    }

    ClassTypeImpl classType(long ref) {
        return (ClassTypeImpl)this.referenceType(ref, 1, null);
    }

    InterfaceTypeImpl interfaceType(long ref) {
        return (InterfaceTypeImpl)this.referenceType(ref, 2, null);
    }

    ArrayTypeImpl arrayType(long ref) {
        return (ArrayTypeImpl)this.referenceType(ref, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceTypeImpl referenceType(long id, int tag, String signature) {
        if ((this.vm.traceFlags & 8) != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Looking up ");
            if (tag == 1) {
                sb.append("Class");
            } else if (tag == 2) {
                sb.append("Interface");
            } else if (tag == 3) {
                sb.append("ArrayType");
            } else {
                sb.append("UNKNOWN TAG: ").append(tag);
            }
            if (signature != null) {
                sb.append(", signature='").append(signature).append('\'');
            }
            sb.append(", id=").append(id);
            this.vm.printTrace(sb.toString());
        }
        if (id == 0L) {
            return null;
        }
        ReferenceTypeImpl retType = null;
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (this.typesByID != null) {
                retType = (ReferenceTypeImpl)this.typesByID.get(id);
            }
            if (retType == null) {
                retType = this.addReferenceType(id, tag, signature);
            }
        }
        return retType;
    }

    private JDWP.VirtualMachine.Capabilities capabilities() {
        if (this.capabilities == null) {
            try {
                this.capabilities = JDWP.VirtualMachine.Capabilities.process(this.vm);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.capabilities;
    }

    private JDWP.VirtualMachine.CapabilitiesNew capabilitiesNew() {
        if (this.capabilitiesNew == null) {
            try {
                this.capabilitiesNew = JDWP.VirtualMachine.CapabilitiesNew.process(this.vm);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.capabilitiesNew;
    }

    private synchronized ModuleReference addModule(long id) {
        if (this.modulesByID == null) {
            this.modulesByID = new HashMap<Long, ModuleReference>(77);
        }
        ModuleReferenceImpl module = new ModuleReferenceImpl(this.vm, id);
        this.modulesByID.put(id, module);
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModuleReference getModule(long id) {
        if (id == 0L) {
            return null;
        }
        ModuleReference module = null;
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (this.modulesByID != null) {
                module = this.modulesByID.get(id);
            }
            if (module == null) {
                module = this.addModule(id);
            }
        }
        return module;
    }

    private synchronized List<ModuleReference> retrieveAllModules() {
        ModuleReferenceImpl[] reqModules;
        try {
            reqModules = JDWP.VirtualMachine.AllModules.process((VirtualMachineImpl)this.vm).modules;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        ArrayList<ModuleReference> modules = new ArrayList<ModuleReference>();
        for (int i = 0; i < reqModules.length; ++i) {
            long moduleRef = reqModules[i].ref();
            ModuleReference module = this.getModule(moduleRef);
            modules.add(module);
        }
        return modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReferenceType> retrieveClassesBySignature(String signature) {
        JDWP.VirtualMachine.ClassesBySignature.ClassInfo[] cinfos;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving matching ReferenceTypes, sig=" + signature);
        }
        try {
            cinfos = JDWP.VirtualMachine.ClassesBySignature.process((VirtualMachineImpl)this.vm, (String)signature).classes;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        int count = cinfos.length;
        ArrayList<ReferenceType> list = new ArrayList<ReferenceType>(count);
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            for (int i = 0; i < count; ++i) {
                JDWP.VirtualMachine.ClassesBySignature.ClassInfo ci = cinfos[i];
                ReferenceTypeImpl type = this.referenceType(ci.typeID, ci.refTypeTag, signature);
                type.setStatus(ci.status);
                list.add(type);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAllClasses1_4() {
        JDWP.VirtualMachine.AllClasses.ClassInfo[] cinfos;
        try {
            cinfos = JDWP.VirtualMachine.AllClasses.process((VirtualMachineImpl)this.vm).classes;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                for (JDWP.VirtualMachine.AllClasses.ClassInfo ci : cinfos) {
                    ReferenceTypeImpl type = this.referenceType(ci.typeID, ci.refTypeTag, ci.signature);
                    type.setStatus(ci.status);
                }
                this.retrievedAllTypes = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retrieveAllClassesWithSuperlcass() {
        JDWP.SapExtensions.AllClassesWithGenericAndSuperclass.ClassInfo[] cinfos;
        if (!this.canUseSapExtensions()) {
            return false;
        }
        try {
            cinfos = JDWP.SapExtensions.AllClassesWithGenericAndSuperclass.process((VirtualMachineImpl)this.vm).classes;
        }
        catch (JDWPException exc) {
            return false;
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                int i;
                int count = cinfos.length;
                ReferenceTypeImpl[] types = new ReferenceTypeImpl[count];
                for (i = 0; i < count; ++i) {
                    JDWP.SapExtensions.AllClassesWithGenericAndSuperclass.ClassInfo ci = cinfos[i];
                    types[i] = this.referenceType(ci.typeID, ci.refTypeTag, ci.signature);
                    types[i].setGenericSignature(ci.genericSignature);
                    types[i].setStatus(ci.status);
                }
                for (i = 0; i < count; ++i) {
                    if (!(types[i] instanceof ClassTypeImpl)) continue;
                    ClassTypeImpl superclass = (ClassTypeImpl)this.typesByID.get(cinfos[i].superclassId);
                    ((ClassTypeImpl)types[i]).setSuperclass(superclass);
                }
                this.retrievedAllTypes = true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAllClasses() {
        JDWP.VirtualMachine.AllClassesWithGeneric.ClassInfo[] cinfos;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving all ReferenceTypes");
        }
        if (!this.vm.canGet1_5LanguageFeatures()) {
            this.retrieveAllClasses1_4();
            return;
        }
        if (this.retrieveAllClassesWithSuperlcass()) {
            return;
        }
        try {
            cinfos = JDWP.VirtualMachine.AllClassesWithGeneric.process((VirtualMachineImpl)this.vm).classes;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                for (JDWP.VirtualMachine.AllClassesWithGeneric.ClassInfo ci : cinfos) {
                    ReferenceTypeImpl type = this.referenceType(ci.typeID, ci.refTypeTag, ci.signature);
                    type.setGenericSignature(ci.genericSignature);
                    type.setStatus(ci.status);
                }
                this.retrievedAllTypes = true;
            }
        }
    }

    void sendToTarget(Packet packet) {
        this.target.send(packet);
    }

    void waitForTargetReply(Packet packet) {
        this.target.waitForReply(packet);
        this.processBatchedDisposes();
    }

    Type findBootType(String signature) throws ClassNotLoadedException {
        List<ReferenceType> types = this.retrieveClassesBySignature(signature);
        for (ReferenceType type : types) {
            if (type.classLoader() != null) continue;
            return type;
        }
        JNITypeParser parser = new JNITypeParser(signature);
        throw new ClassNotLoadedException(parser.typeName(), "Type " + parser.typeName() + " not loaded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BooleanType theBooleanType() {
        if (this.theBooleanType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theBooleanType == null) {
                    this.theBooleanType = new BooleanTypeImpl(this);
                }
            }
        }
        return this.theBooleanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteType theByteType() {
        if (this.theByteType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theByteType == null) {
                    this.theByteType = new ByteTypeImpl(this);
                }
            }
        }
        return this.theByteType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharType theCharType() {
        if (this.theCharType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theCharType == null) {
                    this.theCharType = new CharTypeImpl(this);
                }
            }
        }
        return this.theCharType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortType theShortType() {
        if (this.theShortType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theShortType == null) {
                    this.theShortType = new ShortTypeImpl(this);
                }
            }
        }
        return this.theShortType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntegerType theIntegerType() {
        if (this.theIntegerType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theIntegerType == null) {
                    this.theIntegerType = new IntegerTypeImpl(this);
                }
            }
        }
        return this.theIntegerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LongType theLongType() {
        if (this.theLongType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theLongType == null) {
                    this.theLongType = new LongTypeImpl(this);
                }
            }
        }
        return this.theLongType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FloatType theFloatType() {
        if (this.theFloatType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theFloatType == null) {
                    this.theFloatType = new FloatTypeImpl(this);
                }
            }
        }
        return this.theFloatType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DoubleType theDoubleType() {
        if (this.theDoubleType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theDoubleType == null) {
                    this.theDoubleType = new DoubleTypeImpl(this);
                }
            }
        }
        return this.theDoubleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VoidType theVoidType() {
        if (this.theVoidType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theVoidType == null) {
                    this.theVoidType = new VoidTypeImpl(this);
                }
            }
        }
        return this.theVoidType;
    }

    PrimitiveType primitiveTypeMirror(byte tag) {
        switch (tag) {
            case 90: {
                return this.theBooleanType();
            }
            case 66: {
                return this.theByteType();
            }
            case 67: {
                return this.theCharType();
            }
            case 83: {
                return this.theShortType();
            }
            case 73: {
                return this.theIntegerType();
            }
            case 74: {
                return this.theLongType();
            }
            case 70: {
                return this.theFloatType();
            }
            case 68: {
                return this.theDoubleType();
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive tag " + tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatchedDisposes() {
        if (this.shutdown) {
            return;
        }
        JDWP.VirtualMachine.DisposeObjects.Request[] requests = null;
        List<SoftObjectReference> list = this.batchedDisposeRequests;
        synchronized (list) {
            int size = this.batchedDisposeRequests.size();
            if (size >= 50) {
                if ((this.traceFlags & 0x10) != 0) {
                    this.printTrace("Dispose threashold reached. Will dispose " + size + " object references...");
                }
                requests = new JDWP.VirtualMachine.DisposeObjects.Request[size];
                for (int i = 0; i < requests.length; ++i) {
                    SoftObjectReference ref = this.batchedDisposeRequests.get(i);
                    if ((this.traceFlags & 0x10) != 0) {
                        this.printTrace("Disposing object " + ref.key() + " (ref count = " + ref.count() + ")");
                    }
                    requests[i] = new JDWP.VirtualMachine.DisposeObjects.Request(new ObjectReferenceImpl(this, ref.key()), ref.count());
                }
                this.batchedDisposeRequests.clear();
            }
        }
        if (requests != null) {
            try {
                JDWP.VirtualMachine.DisposeObjects.process(this.vm, requests);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
    }

    private void batchForDispose(SoftObjectReference ref) {
        if ((this.traceFlags & 0x10) != 0) {
            this.printTrace("Batching object " + ref.key() + " for dispose (ref count = " + ref.count() + ")");
        }
        this.batchedDisposeRequests.add(ref);
    }

    private void processQueue() {
        Reference<ObjectReferenceImpl> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            SoftObjectReference softRef = (SoftObjectReference)ref;
            this.removeObjectMirror(softRef);
            this.batchForDispose(softRef);
        }
    }

    synchronized ObjectReferenceImpl objectMirror(long id, int tag) {
        this.processQueue();
        if (id == 0L) {
            return null;
        }
        ObjectReferenceImpl object = null;
        Long key = id;
        SoftObjectReference ref = this.objectsByID.get(key);
        if (ref != null) {
            object = ref.object();
        }
        if (object == null) {
            switch (tag) {
                case 76: {
                    object = new ObjectReferenceImpl(this.vm, id);
                    break;
                }
                case 115: {
                    object = new StringReferenceImpl(this.vm, id);
                    break;
                }
                case 91: {
                    object = new ArrayReferenceImpl(this.vm, id);
                    break;
                }
                case 116: {
                    ThreadReferenceImpl thread = new ThreadReferenceImpl(this.vm, id);
                    thread.addListener(this);
                    object = thread;
                    break;
                }
                case 103: {
                    object = new ThreadGroupReferenceImpl(this.vm, id);
                    break;
                }
                case 108: {
                    object = new ClassLoaderReferenceImpl(this.vm, id);
                    break;
                }
                case 99: {
                    object = new ClassObjectReferenceImpl(this.vm, id);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid object tag: " + tag);
                }
            }
            ref = new SoftObjectReference(key, object, this.referenceQueue);
            this.objectsByID.put(key, ref);
            if ((this.traceFlags & 0x10) != 0) {
                this.printTrace("Creating new " + object.getClass().getName() + " (id = " + id + ")");
            }
        } else {
            ref.incrementCount();
        }
        return object;
    }

    synchronized void removeObjectMirror(ObjectReferenceImpl object) {
        this.processQueue();
        SoftObjectReference ref = this.objectsByID.remove(object.ref());
        if (ref == null) {
            throw new InternalException("ObjectReference " + object.ref() + " not found in object cache");
        }
        this.batchForDispose(ref);
    }

    synchronized void removeObjectMirror(SoftObjectReference ref) {
        this.objectsByID.remove(ref.key());
    }

    ObjectReferenceImpl objectMirror(long id) {
        return this.objectMirror(id, 76);
    }

    StringReferenceImpl stringMirror(long id) {
        return (StringReferenceImpl)this.objectMirror(id, 115);
    }

    ArrayReferenceImpl arrayMirror(long id) {
        return (ArrayReferenceImpl)this.objectMirror(id, 91);
    }

    ThreadReferenceImpl threadMirror(long id) {
        return (ThreadReferenceImpl)this.objectMirror(id, 116);
    }

    ThreadGroupReferenceImpl threadGroupMirror(long id) {
        return (ThreadGroupReferenceImpl)this.objectMirror(id, 103);
    }

    ClassLoaderReferenceImpl classLoaderMirror(long id) {
        return (ClassLoaderReferenceImpl)this.objectMirror(id, 108);
    }

    ClassObjectReferenceImpl classObjectMirror(long id) {
        return (ClassObjectReferenceImpl)this.objectMirror(id, 99);
    }

    ModuleReferenceImpl moduleMirror(long id) {
        return (ModuleReferenceImpl)this.getModule(id);
    }

    private JDWP.VirtualMachine.ClassPaths getClasspath() {
        if (this.pathInfo == null) {
            try {
                this.pathInfo = JDWP.VirtualMachine.ClassPaths.process(this.vm);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.pathInfo;
    }

    @Override
    public List<String> classPath() {
        return Arrays.asList(this.getClasspath().classpaths);
    }

    @Override
    public List<String> bootClassPath() {
        return Collections.emptyList();
    }

    @Override
    public String baseDirectory() {
        return this.getClasspath().baseDir;
    }

    @Override
    public void setDefaultStratum(String stratum) {
        this.defaultStratum = stratum;
        if (stratum == null) {
            stratum = "";
        }
        try {
            JDWP.VirtualMachine.SetDefaultStratum.process(this.vm, stratum);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public String getDefaultStratum() {
        return this.defaultStratum;
    }

    ThreadGroup threadGroupForJDI() {
        return this.threadGroupForJDI;
    }

    @Override
    public boolean canUseSapExtensions() {
        return this.sapExtensionsMajorVersion >= 0 && this.sapExtensionsMinorVersion >= 0;
    }

    @Override
    public boolean canUseStringExtensions() {
        return this.sapExtensionsMajorVersion >= 0 && this.sapExtensionsMinorVersion >= 1;
    }

    @Override
    public Object getTraceContext() {
        return this.traceContext;
    }

    @Override
    public void setTraceContext(Object context) {
        this.traceContext = context;
    }

    @Override
    public List<ReferenceType> visibleClasses(ClassLoaderReference ref) {
        if (ref != null) {
            return ref.visibleClasses();
        }
        ArrayList<ReferenceType> result = null;
        try {
            JDWP.ClassLoaderReference.VisibleClasses.ClassInfo[] jdwpClasses = JDWP.ClassLoaderReference.VisibleClasses.process((VirtualMachineImpl)this.vm, null).classes;
            result = new ArrayList<ReferenceTypeImpl>(jdwpClasses.length);
            for (int i = 0; i < jdwpClasses.length; ++i) {
                result.add(this.vm.referenceType(jdwpClasses[i].typeID, jdwpClasses[i].refTypeTag));
            }
            result = Collections.unmodifiableList(result);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return result;
    }

    @Override
    public boolean hasStackTrackerSupportForAllStepTypes() {
        return this.hasStackTrackerSupportForAllStepTypes;
    }

    @Override
    public boolean hasStackTrackerSupportForStepEnd() {
        return this.hasStackTrackerSupportForAllStepTypes;
    }

    @Override
    public void setConstantPoolMappingCreator(VirtualMachine.ConstantPoolMappingCreator creator) {
        this.constantPoolMappingCreator = creator;
    }

    @Override
    public VirtualMachine.ConstantPoolMappingCreator getConstantPoolMappingCreator() {
        return this.constantPoolMappingCreator;
    }

    private static class SoftObjectReference
    extends SoftReference<ObjectReferenceImpl> {
        int count = 1;
        Long key;

        SoftObjectReference(Long key, ObjectReferenceImpl mirror, ReferenceQueue<ObjectReferenceImpl> queue) {
            super(mirror, queue);
            this.key = key;
        }

        int count() {
            return this.count;
        }

        void incrementCount() {
            ++this.count;
        }

        Long key() {
            return this.key;
        }

        ObjectReferenceImpl object() {
            return (ObjectReferenceImpl)this.get();
        }
    }
}

