/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.jdi;

import com.sap.jvm.jdi.JDIPermission;
import com.sap.jvm.jdi.VMDisconnectedException;
import com.sap.jvm.jdi.VirtualMachine;
import com.sap.jvm.jdi.VirtualMachineManager;
import com.sap.jvm.jdi.connect.AttachingConnector;
import com.sap.jvm.jdi.connect.Connector;
import com.sap.jvm.jdi.connect.LaunchingConnector;
import com.sap.jvm.jdi.connect.ListeningConnector;
import com.sap.jvm.jdi.connect.spi.Connection;
import com.sap.jvm.tools.jdi.GenericAttachingConnector;
import com.sap.jvm.tools.jdi.GenericListeningConnector;
import com.sap.jvm.tools.jdi.SocketAttachingConnector;
import com.sap.jvm.tools.jdi.SocketTransportService;
import com.sap.jvm.tools.jdi.VirtualMachineImpl;
import com.sap.jvm.tools.jdi.VirtualMachineManagerService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;

public class VirtualMachineManagerImpl
implements VirtualMachineManagerService {
    private List<Connector> connectors = new ArrayList<Connector>();
    private LaunchingConnector defaultConnector = null;
    private List<VirtualMachine> targets = new ArrayList<VirtualMachine>();
    private final ThreadGroup mainGroupForJDI;
    private ResourceBundle messages = null;
    private int vmSequenceNumber = 0;
    private static final int majorVersion = 9;
    private static final int minorVersion = 0;
    private static final Object lock = new Object();
    private static VirtualMachineManagerImpl vmm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualMachineManager virtualMachineManager() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            JDIPermission vmmPermission = new JDIPermission("virtualMachineManager");
            sm.checkPermission(vmmPermission);
        }
        Object object = lock;
        synchronized (object) {
            if (vmm == null) {
                vmm = new VirtualMachineManagerImpl();
            }
        }
        return vmm;
    }

    protected VirtualMachineManagerImpl() {
        ThreadGroup top = Thread.currentThread().getThreadGroup();
        ThreadGroup parent = null;
        while ((parent = top.getParent()) != null) {
            top = parent;
        }
        this.mainGroupForJDI = new ThreadGroup(top, "JDI main");
        this.addConnector(new SocketAttachingConnector());
        this.addConnector(GenericAttachingConnector.create(new SocketTransportService()));
        this.addConnector(GenericListeningConnector.create(new SocketTransportService()));
        if (this.allConnectors().size() == 0) {
            throw new Error("no Connectors loaded");
        }
        boolean found = false;
        List<LaunchingConnector> launchers = this.launchingConnectors();
        for (LaunchingConnector lc : launchers) {
            if (!lc.name().equals("com.sun.jdi.CommandLineLaunch")) continue;
            this.setDefaultConnector(lc);
            found = true;
            break;
        }
        if (!found && launchers.size() > 0) {
            this.setDefaultConnector(launchers.get(0));
        }
    }

    @Override
    public LaunchingConnector defaultConnector() {
        if (this.defaultConnector == null) {
            throw new Error("no default LaunchingConnector");
        }
        return this.defaultConnector;
    }

    @Override
    public void setDefaultConnector(LaunchingConnector connector) {
        this.defaultConnector = connector;
    }

    @Override
    public List<LaunchingConnector> launchingConnectors() {
        ArrayList<LaunchingConnector> launchingConnectors = new ArrayList<LaunchingConnector>(this.connectors.size());
        for (Connector connector : this.connectors) {
            if (!(connector instanceof LaunchingConnector)) continue;
            launchingConnectors.add((LaunchingConnector)connector);
        }
        return Collections.unmodifiableList(launchingConnectors);
    }

    @Override
    public List<AttachingConnector> attachingConnectors() {
        ArrayList<AttachingConnector> attachingConnectors = new ArrayList<AttachingConnector>(this.connectors.size());
        for (Connector connector : this.connectors) {
            if (!(connector instanceof AttachingConnector)) continue;
            attachingConnectors.add((AttachingConnector)connector);
        }
        return Collections.unmodifiableList(attachingConnectors);
    }

    @Override
    public List<ListeningConnector> listeningConnectors() {
        ArrayList<ListeningConnector> listeningConnectors = new ArrayList<ListeningConnector>(this.connectors.size());
        for (Connector connector : this.connectors) {
            if (!(connector instanceof ListeningConnector)) continue;
            listeningConnectors.add((ListeningConnector)connector);
        }
        return Collections.unmodifiableList(listeningConnectors);
    }

    @Override
    public List<Connector> allConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    @Override
    public List<VirtualMachine> connectedVirtualMachines() {
        return Collections.unmodifiableList(this.targets);
    }

    @Override
    public void addConnector(Connector connector) {
        this.connectors.add(connector);
    }

    @Override
    public void removeConnector(Connector connector) {
        this.connectors.remove(connector);
    }

    @Override
    public synchronized VirtualMachine createVirtualMachine(Connection connection, Process process) throws IOException {
        VirtualMachineImpl vm;
        if (!connection.isOpen()) {
            throw new IllegalStateException("connection is not open");
        }
        try {
            vm = new VirtualMachineImpl(this, connection, process, ++this.vmSequenceNumber);
        }
        catch (VMDisconnectedException e) {
            throw new IOException(e.getMessage());
        }
        this.targets.add(vm);
        return vm;
    }

    @Override
    public VirtualMachine createVirtualMachine(Connection connection) throws IOException {
        return this.createVirtualMachine(connection, null);
    }

    public void addVirtualMachine(VirtualMachine vm) {
        this.targets.add(vm);
    }

    void disposeVirtualMachine(VirtualMachine vm) {
        this.targets.remove(vm);
    }

    @Override
    public int majorInterfaceVersion() {
        return 9;
    }

    @Override
    public int minorInterfaceVersion() {
        return 0;
    }

    ThreadGroup mainGroupForJDI() {
        return this.mainGroupForJDI;
    }

    String getString(String key) {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle("com.sap.jvm.tools.jdi.resources.jdi");
        }
        return this.messages.getString(key);
    }
}

