/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.monitor.cluster.ClusterType;
import java.util.ArrayList;

public class ClusterConnection {
    private MonitoringController controller;
    private int id;
    private int index;
    private boolean isCluster;
    private ClusterType type;

    public ClusterConnection(MonitoringController controller, int pid) {
        this.controller = controller;
        this.id = pid;
        this.index = -1;
        this.isCluster = false;
        this.type = ClusterType.CLUSTER_TYPE_PROCESS;
    }

    public ClusterConnection(MonitoringController controller, int instanceNo, int index) {
        this.controller = controller;
        this.id = instanceNo;
        this.index = index;
        this.isCluster = true;
        this.type = ClusterType.CLUSTER_TYPE_INSTANCE;
    }

    public MonitoringController getMonitoringController() {
        return this.controller;
    }

    public MonitoredVm getVm() {
        if (this.isCluster) {
            for (MonitoredVm vm : this.controller.getAllMonitoredVms(true)) {
                if (vm.getBoard().getClusterIndex() != this.index || vm.getBoard().getInstanceNr() != this.id) continue;
                return vm;
            }
        } else {
            for (MonitoredVm vm : this.controller.getAllMonitoredVms(true)) {
                if (vm.getBoard().getPid() != this.id) continue;
                return vm;
            }
        }
        return null;
    }

    public MonitoredVm[] getVms() {
        if (this.isCluster) {
            ArrayList<MonitoredVm> result = new ArrayList<MonitoredVm>();
            for (MonitoredVm vm : this.controller.getAllMonitoredVms(true)) {
                if (vm.getBoard().getInstanceNr() != this.id) continue;
                result.add(vm);
            }
            return result.toArray(new MonitoredVm[result.size()]);
        }
        MonitoredVm[] result = null;
        MonitoredVm vm = this.getVm();
        result = vm == null ? new MonitoredVm[]{} : new MonitoredVm[]{vm};
        return result;
    }

    public MonitoredVm[] getSelectedVms() {
        MonitoredVm[] monitoredVmArray;
        if (this.isCluster && this.index < 0) {
            ArrayList<MonitoredVm> result = new ArrayList<MonitoredVm>();
            for (MonitoredVm vm : this.controller.getAllMonitoredVms(true)) {
                if (vm.getBoard().getInstanceNr() != this.id) continue;
                result.add(vm);
            }
            return result.toArray(new MonitoredVm[result.size()]);
        }
        MonitoredVm vm = this.getVm();
        if (vm == null) {
            monitoredVmArray = new MonitoredVm[]{};
        } else {
            MonitoredVm[] monitoredVmArray2 = new MonitoredVm[1];
            monitoredVmArray = monitoredVmArray2;
            monitoredVmArray2[0] = vm;
        }
        return monitoredVmArray;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public ClusterType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }
}

