/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Formatter {
    private static SimpleDateFormat formater = new SimpleDateFormat("d.MM.yyyy HH:mm:ss");
    private static DecimalFormat decimalFormatterDouble = new DecimalFormat("###,###.###");
    private static DecimalFormat decimalFormatterDoubleTwoDigits = new DecimalFormat("###,###.##");
    private static DecimalFormat decimalFormatterLong = new DecimalFormat();
    private static final long MS_US = 1000L;
    private static final long SECOND_US = 1000000L;
    private static final long MINUTE_US = 60000000L;
    private static final long HOUR_US = 3600000000L;
    private static final long DAY_US = 86400000000L;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;

    public static String formatTS(long ms) {
        if (ms > 0L) {
            return formater.format(new Date(ms));
        }
        return "-.--.---- --:--:--";
    }

    public static String formatTime(long timeInUs) {
        long us = timeInUs;
        if (us < 0L) {
            return "--:--:--";
        }
        if (us == 0L) {
            return "0 us";
        }
        StringBuffer result = new StringBuffer();
        long d = 0L;
        long h = 0L;
        long min = 0L;
        long sec = 0L;
        long ms = 0L;
        if (us >= 86400000000L) {
            d = us / 86400000000L;
            us -= 86400000000L * d;
        }
        if (us >= 3600000000L) {
            h = us / 3600000000L;
            us -= 3600000000L * h;
        }
        if (us >= 60000000L) {
            min = us / 60000000L;
            us -= 60000000L * min;
        }
        if (us >= 1000000L) {
            sec = us / 1000000L;
            us -= 1000000L * sec;
        }
        if (us >= 1000L) {
            ms = us / 1000L;
            us -= 1000L * ms;
        }
        if (d > 0L) {
            result.append(d);
            result.append(" d ");
        }
        if (h > 0L) {
            result.append(h);
            result.append(" h ");
        }
        if (min > 0L) {
            result.append(min);
            result.append(" min ");
        }
        if (sec > 0L) {
            result.append(sec);
            result.append(" sec ");
        }
        if (ms > 0L) {
            result.append(ms);
            result.append(" ms ");
        }
        if (us > 0L) {
            result.append(us);
            result.append(" us ");
        }
        return result.toString();
    }

    public static String formatTimeMs(long timeInMs) {
        long ms = timeInMs;
        if (ms < 0L) {
            return "--:--:--";
        }
        if (ms == 0L) {
            return "0 ms";
        }
        StringBuffer result = new StringBuffer();
        long d = 0L;
        long h = 0L;
        long min = 0L;
        long sec = 0L;
        if (ms >= 86400000L) {
            d = ms / 86400000L;
            ms -= 86400000L * d;
        }
        if (ms >= 3600000L) {
            h = ms / 3600000L;
            ms -= 3600000L * h;
        }
        if (ms >= 60000L) {
            min = ms / 60000L;
            ms -= 60000L * min;
        }
        if (ms >= 1000L) {
            sec = ms / 1000L;
            ms -= 1000L * sec;
        }
        if (d > 0L) {
            result.append(d);
            result.append(" d ");
        }
        if (h > 0L) {
            result.append(h);
            result.append(" h ");
        }
        if (min > 0L) {
            result.append(min);
            result.append(" min ");
        }
        if (sec > 0L) {
            result.append(sec);
            result.append(" s ");
        }
        if (ms > 0L) {
            result.append(ms);
            result.append(" ms ");
        }
        return result.toString();
    }

    public static String formatTimeMsRound(long timeInMs) {
        long ms = timeInMs;
        if (ms < 0L) {
            return "--:--:--";
        }
        if (ms == 0L) {
            return "0 ms";
        }
        if (ms >= 86400000L) {
            double result = (double)timeInMs / 8.64E7;
            return decimalFormatterDoubleTwoDigits.format(result) + " d";
        }
        if (ms >= 3600000L) {
            double result = (double)timeInMs / 3600000.0;
            return decimalFormatterDoubleTwoDigits.format(result) + " h";
        }
        if (ms >= 60000L) {
            double result = (double)timeInMs / 60000.0;
            return decimalFormatterDoubleTwoDigits.format(result) + " min";
        }
        if (ms >= 1000L) {
            double result = (double)timeInMs / 1000.0;
            return decimalFormatterDoubleTwoDigits.format(result) + " s";
        }
        return decimalFormatterDoubleTwoDigits.format(timeInMs) + " ms";
    }

    public static String formatTimeMsInElements(long timeInMs) {
        long ms = timeInMs;
        if (ms < 0L) {
            return "--:--:--";
        }
        if (ms == 0L) {
            return "0:00:00";
        }
        long d = 0L;
        long h = 0L;
        long min = 0L;
        long sec = 0L;
        if (ms >= 86400000L) {
            d = ms / 86400000L;
            ms -= 86400000L * d;
        }
        if (ms >= 3600000L) {
            h = ms / 3600000L;
            ms -= 3600000L * h;
        }
        if (ms >= 60000L) {
            min = ms / 60000L;
            ms -= 60000L * min;
        }
        if (ms >= 1000L) {
            sec = ms / 1000L;
            ms -= 1000L * sec;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(h += d * 24L).append(':');
        if (min < 10L) {
            buffer.append('0');
        }
        buffer.append(min).append(':');
        if (sec < 10L) {
            buffer.append('0');
        }
        buffer.append(sec);
        return buffer.toString();
    }

    public static String formatMem(long sizeInBytes) {
        long bytes = sizeInBytes;
        if (bytes < 0L) {
            return "???";
        }
        if (bytes == 0L) {
            return "0 Byte";
        }
        StringBuffer result = new StringBuffer();
        long kb = 0L;
        long mb = 0L;
        long gb = 0L;
        if (bytes >= 0x40000000L) {
            gb = bytes / 0x40000000L;
            bytes -= 0x40000000L * gb;
        }
        if (bytes >= 0x100000L) {
            mb = bytes / 0x100000L;
            bytes -= 0x100000L * mb;
        }
        if (bytes >= 1024L) {
            kb = bytes / 1024L;
            bytes -= 1024L * kb;
        }
        if (gb > 0L) {
            result.append(gb);
            result.append(" GB ");
        }
        if (mb > 0L) {
            result.append(mb);
            result.append(" MB ");
        }
        if (kb > 0L) {
            result.append(kb);
            result.append(" KB ");
        }
        if (bytes > 0L) {
            result.append(bytes);
            result.append(" Byte");
        }
        return result.toString();
    }

    public static String formatMemRound(long bytes) {
        if (bytes < 0L) {
            return "???";
        }
        if (bytes == 0L) {
            return "0 Byte";
        }
        double result = 0.0;
        if (bytes >= 0x40000000L) {
            result = (double)bytes / 1.073741824E9;
            return decimalFormatterDouble.format(result) + " GB";
        }
        if (bytes >= 0x100000L) {
            result = (double)bytes / 1048576.0;
            return decimalFormatterDouble.format(result) + " MB";
        }
        if (bytes >= 1024L) {
            result = (double)bytes / 1024.0;
            return decimalFormatterDouble.format(result) + " KB";
        }
        result = bytes;
        return decimalFormatterDouble.format(result) + " Bytes";
    }

    public static String formatMemGB(long bytes) {
        if (bytes < 0L) {
            return "???";
        }
        double result = (double)bytes / 1.073741824E9;
        return decimalFormatterDouble.format(result) + " GB";
    }

    public static String formatMemMB(long bytes) {
        if (bytes < 0L) {
            return "???";
        }
        double result = (double)bytes / 1048576.0;
        return decimalFormatterDouble.format(result) + " MB";
    }

    public static String formatMemKB(long bytes) {
        if (bytes < 0L) {
            return "???";
        }
        double result = (double)bytes / 1024.0;
        return decimalFormatterDouble.format(result) + " KB";
    }

    public static String formatMemBytes(long bytes) {
        if (bytes < 0L) {
            return "???";
        }
        return decimalFormatterLong.format(bytes) + " Bytes";
    }

    public static String formatMemSimple(long bytes) {
        return decimalFormatterLong.format(bytes) + " Bytes";
    }

    public static String formatDouble(double number) {
        return decimalFormatterLong.format(number);
    }

    public static String formatTimeInMsSimple(long time) {
        return decimalFormatterLong.format(time) + " ms";
    }
}

