/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon;

import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.JvmmonArgs;
import com.sap.jvm.tools.monitor.jvmmon.gui.JvmMonGui;
import com.sap.jvm.util.misc.ToolsHelper;

public class JvmMon {
    private static boolean isNewJvmmon = false;

    public static boolean isNew() {
        return isNewJvmmon;
    }

    public static void setNew(boolean isNew) {
        isNewJvmmon = isNew;
    }

    static String usage() {
        return "Usage: jvmmon [options]\n\n where options include:\n    --help|-h|-?\n            Print this help text.\n    --gui|-g\n            Start the GUI version.\n    --verbose\n            Enables verbose tracing of jvmmon operation.\n    --trace-file <trace file>\n            Directs tracing of jvmmon operation to trace file.\n    --new\n            Use the new jvmmond protocol.\n    -hostname <hostname>\n            Name of a remote host to connect to (requires jvmmond process on remote host).\n    -port <port>\n             Port on which jvmmond is listening on remote host.\n    -cmd <fileName>\n            Name of file containing jvmmon commands to execute.\n    -c <command>\n            A single command to execute.\n    -pid <pid> | -sapSystem <id>[:<index>]\n            Process ID or SAP JVM cluster ID/index of target JVM to connect to.\n\n example: jvmmon -pid 31675 -c \"force gc\"\n";
    }

    public static void main(String[] args) {
        JvmmonArgs jvmmonArgs;
        try {
            jvmmonArgs = JvmmonArgs.parse(args);
        }
        catch (JvmmonArgs.IllegalJvmmonArgsException e) {
            System.err.println(e.getMessage() + "\n" + JvmMon.usage());
            System.exit(1);
            return;
        }
        if (jvmmonArgs.printHelp) {
            System.out.println(JvmMon.usage());
        } else {
            ToolsHelper.setToolsTracingLevel((boolean)jvmmonArgs.verbose, (String)jvmmonArgs.traceFileName);
            isNewJvmmon = jvmmonArgs.isNewJvmmon;
            if (jvmmonArgs.startGui) {
                JvmMonGui.start();
            } else {
                JvmMonConsole.start(jvmmonArgs);
            }
        }
    }
}

