/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.inspector.jvmmon.PasswordSupplier;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.VmInfo;
import com.sap.jvm.tools.console.Completor;
import com.sap.jvm.tools.console.ConsoleReader;
import com.sap.jvm.tools.console.ConsoleWriter;
import com.sap.jvm.tools.monitor.jvmmon.ClusterConnection;
import com.sap.jvm.tools.monitor.jvmmon.JvmMon;
import com.sap.jvm.tools.monitor.jvmmon.JvmmonArgs;
import com.sap.jvm.tools.monitor.jvmmon.command.ChangeCommandLineFlagsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ClassLoaderDataGraphCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ClassStatisticCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.CodeBlobsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.CrashVmCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DeoptimizeAllCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DeoptimizeMethodCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DetailedClassStatisticCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DisplayVmsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DllInformationCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DumpHeapCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DumpSafepointStateCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.DumpStackTraceWithInfoCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ExitCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ExitVmCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.FlightrecorderCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ForceCompileCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ForceGcCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ForceMaxGcCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.ForceOSRCompileCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.GcHistoryCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.HelpCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.HistoryCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.HsErrInfoCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.JITInformationCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.MallocStatisticsResetCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.MallocStatisticsStartCaptureCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.MallocStatisticsStopCaptureCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintClusterMemoryInformationCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintDebuggingInformationCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintMallocStatisticsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintMallocStatisticsInternalsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintMemoryHistoryCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintMetaspaceMapCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintMetaspaceStatisticsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintSignalHandlersCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintSystemInfoCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintSystemPropertiesCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintTraceFlagsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintVirtualizationInfoCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintVmCompressedClassSpaceDetails;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintVmInformationCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintVmMemoryInformationCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.PrintVmPerformanceInformationCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.QuitCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.RetrieveGcHistoryCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.SelectVmCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.SetCoreSizeToMax;
import com.sap.jvm.tools.monitor.jvmmon.command.SetDebuggingPortCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.SetDebuggingPortRangeCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.SetDumpFileCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.SetTraceFlagsCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.StackTraceCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.StartDebuggingCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.StopCommandLineProfilingCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.StopDebuggingCommand;
import com.sap.jvm.tools.monitor.jvmmon.command.SymbolInformationCommand;
import com.sap.jvm.tools.util.Tokenizer;
import com.sap.jvm.tracing.Trace;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class JvmMonConsole
implements Completor {
    private ConsoleReader input = null;
    private ConsoleWriter output = new ConsoleWriter();
    private ClusterConnection connection = null;
    private List<Command> commands = new ArrayList<Command>();

    private boolean addCommand(Command cmd) {
        this.commands.add(cmd);
        return true;
    }

    private void initializeCommands(boolean oldJvmmondClient) throws InvalidVmException {
        this.commands.clear();
        this.addCommand(new ClassLoaderDataGraphCommand(this, true));
        this.addCommand(new ClassLoaderDataGraphCommand(this, false));
        this.addCommand(new ClassStatisticCommand(this, true));
        this.addCommand(new ClassStatisticCommand(this, false));
        this.addCommand(new CodeBlobsCommand(this, true));
        this.addCommand(new CodeBlobsCommand(this, false));
        this.addCommand(new CrashVmCommand(this));
        this.addCommand(new DeoptimizeAllCommand(this));
        this.addCommand(new DeoptimizeMethodCommand(this));
        this.addCommand(new DetailedClassStatisticCommand(this, true));
        this.addCommand(new DetailedClassStatisticCommand(this, false));
        this.addCommand(new DisplayVmsCommand(this));
        this.addCommand(new DllInformationCommand(this, true));
        this.addCommand(new DllInformationCommand(this, false));
        this.addCommand(new DumpHeapCommand(this));
        this.addCommand(new DumpSafepointStateCommand(this));
        this.addCommand(new DumpStackTraceWithInfoCommand(this));
        this.addCommand(new ExitCommand(this));
        this.addCommand(new ExitVmCommand(this));
        this.addCommand(new FlightrecorderCommand(this, true));
        this.addCommand(new FlightrecorderCommand(this, false));
        this.addCommand(new ForceCompileCommand(this));
        this.addCommand(new ForceGcCommand(this));
        this.addCommand(new ForceMaxGcCommand(this));
        this.addCommand(new ForceOSRCompileCommand(this));
        this.addCommand(new GcHistoryCommand(this, true));
        this.addCommand(new GcHistoryCommand(this, false));
        this.addCommand(new HelpCommand(this));
        this.addCommand(new HistoryCommand(this));
        this.addCommand(new HsErrInfoCommand(this, true));
        this.addCommand(new HsErrInfoCommand(this, false));
        this.addCommand(new JITInformationCommand(this, true));
        this.addCommand(new JITInformationCommand(this, false));
        this.addCommand(new MallocStatisticsResetCommand(this));
        this.addCommand(new MallocStatisticsStartCaptureCommand(this));
        this.addCommand(new MallocStatisticsStopCaptureCommand(this));
        this.addCommand(new PrintClusterMemoryInformationCommand(this));
        this.addCommand(new PrintDebuggingInformationCommand(this));
        this.addCommand(new PrintMallocStatisticsCommand(this, true));
        this.addCommand(new PrintMallocStatisticsCommand(this, false));
        this.addCommand(new PrintMallocStatisticsInternalsCommand(this, true));
        this.addCommand(new PrintMallocStatisticsInternalsCommand(this, false));
        this.addCommand(new PrintMemoryHistoryCommand(this, true));
        this.addCommand(new PrintMemoryHistoryCommand(this, false));
        this.addCommand(new PrintMetaspaceMapCommand(this, true));
        this.addCommand(new PrintMetaspaceMapCommand(this, false));
        this.addCommand(new PrintMetaspaceStatisticsCommand(this, true));
        this.addCommand(new PrintMetaspaceStatisticsCommand(this, false));
        this.addCommand(new PrintSignalHandlersCommand(this, true));
        this.addCommand(new PrintSignalHandlersCommand(this, false));
        this.addCommand(new PrintSystemInfoCommand(this, true));
        this.addCommand(new PrintSystemInfoCommand(this, false));
        this.addCommand(new PrintSystemPropertiesCommand(this, true));
        this.addCommand(new PrintSystemPropertiesCommand(this, false));
        this.addCommand(new PrintTraceFlagsCommand(this));
        this.addCommand(new PrintVirtualizationInfoCommand(this));
        this.addCommand(new PrintVmCompressedClassSpaceDetails(this, true));
        this.addCommand(new PrintVmCompressedClassSpaceDetails(this, false));
        this.addCommand(new PrintVmInformationCommand(this));
        this.addCommand(new PrintVmMemoryInformationCommand(this));
        this.addCommand(new PrintVmPerformanceInformationCommand(this));
        this.addCommand(new QuitCommand(this));
        this.addCommand(new RetrieveGcHistoryCommand(this));
        this.addCommand(new SelectVmCommand(this, true));
        this.addCommand(new SelectVmCommand(this, false));
        this.addCommand(new SetDebuggingPortCommand(this));
        this.addCommand(new SetDebuggingPortRangeCommand(this));
        this.addCommand(new SetDumpFileCommand(this, true));
        this.addCommand(new SetDumpFileCommand(this, false));
        this.addCommand(new SetTraceFlagsCommand(this));
        this.addCommand(new StackTraceCommand(this, true));
        this.addCommand(new StackTraceCommand(this, false));
        this.addCommand(new StartDebuggingCommand(this));
        this.addCommand(new StopDebuggingCommand(this));
        this.addCommand(new SymbolInformationCommand(this, true));
        this.addCommand(new SymbolInformationCommand(this, false));
        if (!oldJvmmondClient) {
            this.addCommand(new ChangeCommandLineFlagsCommand(this));
            this.addCommand(new SetCoreSizeToMax(this));
            this.addCommand(new StopCommandLineProfilingCommand(this));
        }
        Collections.sort(this.commands);
    }

    private boolean handleCommand(String line) throws IOException {
        int i;
        LinkedList<String> candidates;
        String commandString = line;
        int lastIndex = commandString.length();
        do {
            candidates = new LinkedList<String>();
            this.complete(commandString, candidates);
            lastIndex = commandString.lastIndexOf(" ", lastIndex);
            if (lastIndex == -1) break;
            commandString = commandString.substring(0, lastIndex).trim();
        } while (candidates.size() == 0);
        int exactMatchIndex = -1;
        if (candidates.size() == 1) {
            exactMatchIndex = 0;
        } else {
            for (i = 0; i < candidates.size(); ++i) {
                if (!line.startsWith(candidates.get(i))) continue;
                exactMatchIndex = i;
                break;
            }
        }
        if (candidates.size() == 0) {
            System.out.println("Unknown command: " + line);
            return false;
        }
        if (exactMatchIndex >= 0) {
            for (i = 0; i < this.commands.size(); ++i) {
                if (!candidates.get(exactMatchIndex).equals(this.commands.get(i).getOpcode())) continue;
                String opcode = this.commands.get(i).getOpcode();
                int pos = 0;
                for (int j = 0; j < line.length() && j < opcode.length() && line.charAt(j) == opcode.charAt(j); ++j) {
                    ++pos;
                }
                String arguments = line.substring(pos).trim();
                String[] args = Tokenizer.split(arguments, " ");
                return this.commands.get(i).execute(args);
            }
        } else {
            System.out.print("Ambiguous command \"" + line + "\": ");
            for (i = 0; i < candidates.size() - 1; ++i) {
                System.out.print(candidates.get(i) + ", ");
            }
            System.out.println(candidates.get(candidates.size() - 1));
        }
        return false;
    }

    private String normalizeCommand(String command) {
        char[] cmdChars = command.trim().toCharArray();
        int writePos = 0;
        boolean whiteSpaceSequence = false;
        for (int readPos = 0; readPos < cmdChars.length; ++readPos) {
            if (cmdChars[readPos] == ' ') {
                if (whiteSpaceSequence) continue;
                whiteSpaceSequence = true;
            } else {
                whiteSpaceSequence = false;
            }
            cmdChars[writePos++] = cmdChars[readPos];
        }
        char[] normalizedChars = new char[writePos];
        System.arraycopy(cmdChars, 0, normalizedChars, 0, writePos);
        return new String(normalizedChars);
    }

    private void commandLoop() throws IOException {
        String line;
        while ((line = this.input.readLine(false)) != null) {
            if ((line = this.normalizeCommand(line)).trim().length() == 0) continue;
            if (this.input.isHistoryCommand(line)) {
                if ((line = this.input.getHistoryCommand(line)) == null) continue;
                System.out.println(line);
            }
            this.handleCommand(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCommandFile(String cmdFile) throws IOException {
        try (BufferedReader commandReader = null;){
            commandReader = new BufferedReader(new InputStreamReader(new FileInputStream(cmdFile)));
            String nextCommand = null;
            boolean failure = false;
            while ((nextCommand = commandReader.readLine()) != null && !failure) {
                if (nextCommand.length() <= 0) continue;
                failure = !this.handleCommand(nextCommand);
            }
            if (failure) {
                System.err.println("Stopped processing the command file " + cmdFile);
            }
        }
    }

    private void parseDirectCommands(List<String> cmds) throws IOException {
        for (String nextCommand : cmds) {
            boolean failure;
            if (nextCommand.length() <= 0 || !(failure = !this.handleCommand(nextCommand))) continue;
            System.err.println("Stopped processing the direct command " + nextCommand);
            return;
        }
    }

    private ClusterConnection createClusterConnection(MonitoringController controller, int pid, int sapSystem, int clusterIndex) {
        ClusterConnection result = null;
        if (pid > 0 && controller.getVmForPid(pid, true) != null && controller.getVmForPid(pid, true).isAlive() && pid != VmInfo.getStateInfo().getPid()) {
            result = new ClusterConnection(controller, pid);
        }
        if (result == null && sapSystem >= 0) {
            MonitoredVm[] vms = controller.getInstanceVms(sapSystem);
            if (clusterIndex >= 0) {
                for (int i = 0; i < vms.length && result == null; ++i) {
                    if (!vms[i].isAlive() || vms[i].getBoard().getClusterIndex() != clusterIndex) continue;
                    result = new ClusterConnection(controller, sapSystem, clusterIndex);
                }
            } else if (vms.length > 0) {
                result = new ClusterConnection(controller, sapSystem, -1);
            }
        }
        if (result == null) {
            if (pid != -1 || sapSystem != -1) {
                String errorString = null;
                if (pid != -1) {
                    errorString = "Cannot find (or attach to) VM with pid " + pid;
                } else if (sapSystem != -1) {
                    errorString = "Cannot find (or attach to) VM in cluster with instance number " + sapSystem + " and cluster index " + clusterIndex;
                }
                if (!controller.isLocal()) {
                    errorString = errorString + " on " + controller.getHost() + ":" + controller.getPort();
                }
                System.err.println(errorString);
            } else {
                System.err.println("Either -pid or -sapSystem has to be set.\n\n" + JvmMon.usage());
            }
        }
        return result;
    }

    private JvmMonConsole(boolean consoleMode, MonitoringController mc, int pid, int instanceNo, int clusterIndex) throws IOException {
        this.input = consoleMode ? new ConsoleReader(this) : null;
        this.connection = pid == -1 && instanceNo == -1 ? this.selectVm(mc) : this.createClusterConnection(mc, pid, instanceNo, clusterIndex);
    }

    public static void start(JvmmonArgs jvmmonArgs) {
        MonitoringController controller;
        try {
            controller = new MonitoringController(jvmmonArgs.hostname, jvmmonArgs.port, new PasswordSupplier(){

                public String get() throws IOException {
                    System.out.print("Password: ");
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    return br.readLine();
                }
            }, !JvmMon.isNew());
        }
        catch (IOException e) {
            Trace.get(JvmMonConsole.class).warn((Throwable)e);
            System.err.println("Could not connect to " + jvmmonArgs.hostname + " at port " + jvmmonArgs.port + ". Reason: " + e.getMessage());
            return;
        }
        if (InspectorInfo.couldElevate()) {
            System.err.println("WARNING: jvmmon is not run as administrator. This might limit the number of visible JVMs.");
        }
        try {
            if (jvmmonArgs.cmdFile == null && jvmmonArgs.directCommands == null) {
                JvmMonConsole jmc = new JvmMonConsole(true, controller, jvmmonArgs.pid, jvmmonArgs.instanceNo, jvmmonArgs.clusterIndex);
                if (jmc.connection == null) {
                    return;
                }
                jmc.initializeCommands(controller.isOldJvmmond());
                jmc.commandLoop();
            } else {
                if (jvmmonArgs.pid == -1 && jvmmonArgs.instanceNo == -1) {
                    controller.close();
                    return;
                }
                JvmMonConsole jmc = new JvmMonConsole(false, controller, jvmmonArgs.pid, jvmmonArgs.instanceNo, jvmmonArgs.clusterIndex);
                if (jmc.connection == null) {
                    return;
                }
                jmc.initializeCommands(controller.isOldJvmmond());
                if (jvmmonArgs.cmdFile != null) {
                    jmc.parseCommandFile(jvmmonArgs.cmdFile);
                }
                if (jvmmonArgs.directCommands != null) {
                    jmc.parseDirectCommands(jvmmonArgs.directCommands);
                }
            }
        }
        catch (InvalidVmException | IOException ive) {
            ive.printStackTrace();
            return;
        }
    }

    public boolean switchToClusterConnection(ClusterConnection newConnection) {
        boolean success = false;
        if (newConnection.getSelectedVms() != null) {
            this.setClusterConnection(newConnection);
            try {
                this.initializeCommands(newConnection.getMonitoringController().isOldJvmmond());
                success = true;
            }
            catch (InvalidVmException invalidVmException) {
                // empty catch block
            }
        }
        return success;
    }

    @Override
    public void complete(String buffer, List<String> candidates) {
        int i;
        ArrayList<String> selection = new ArrayList<String>();
        for (i = 0; i < this.commands.size(); ++i) {
            selection.add(this.commands.get(i).getOpcode());
        }
        for (i = 0; i < selection.size(); ++i) {
            if (!((String)selection.get(i)).startsWith(buffer)) continue;
            candidates.add((String)selection.get(i));
        }
        Collections.sort(candidates);
    }

    public void printVMListHeader() {
        System.out.println();
        System.out.println(VMListColumn.getTitle());
        System.out.println(VMListColumn.getBar());
        System.out.println();
    }

    public void listVM(MonitoredVm vm, boolean selected, int instanceID) {
        if (vm == null) {
            return;
        }
        BoardWrapper board = vm.getBoard();
        int pid = board.getPid();
        String javaCmd = board.getJavaArgumentLine();
        String workingDir = board.getWorkingDirectory();
        String vmtag = board.getVmTag();
        long cpuTime = board.getCpuTime() / 1000L;
        String selectMarker = selected && instanceID >= 0 ? "(*)" : "";
        String vmLine = instanceID >= 0 ? VMListColumn.COLUMN_CLUSTER_INFO.getColumn(selectMarker, instanceID, board.getClusterIndex()) : VMListColumn.COLUMN_CLUSTER_INFO.getColumn(new Object[0]);
        vmLine = vmLine + VMListColumn.COLUMN_PID.getColumn(pid);
        vmLine = vmLine + VMListColumn.COLUMN_CPU.getColumn(cpuTime);
        System.out.print(vmLine);
        char[] pads = new char[vmLine.length() + 2];
        Arrays.fill(pads, ' ');
        System.out.print("  ");
        System.out.println(vmtag);
        System.out.print(new String(pads));
        if (board.getJarFileName() != null) {
            System.out.print("-jar ");
            System.out.print(board.getJarFileName());
            System.out.print("[main class: ");
            System.out.print(board.getMainClass());
            System.out.print("]");
            for (String arg : board.getJavaArguments()) {
                System.out.print(" ");
                System.out.print(arg);
            }
            System.out.println();
        } else {
            System.out.println(javaCmd);
        }
        System.out.print(new String(pads));
        System.out.println(workingDir);
        System.out.println();
    }

    private void listVMConnections(Collection<ClusterConnection> conns) {
        this.printVMListHeader();
        ClusterConnection lastConnection = null;
        for (ClusterConnection conn : conns) {
            boolean clusterEnd;
            boolean bl = clusterEnd = lastConnection != null && (lastConnection.isCluster() != conn.isCluster() || lastConnection.getId() != conn.getId());
            if (clusterEnd) {
                System.out.println(VMListColumn.getBar());
                System.out.println();
            }
            int instanceId = conn.isCluster() ? conn.getId() : -1;
            this.listVM(conn.getVm(), false, instanceId);
            lastConnection = conn;
        }
        System.out.println(VMListColumn.getBar());
    }

    public void listClusterVMs(ClusterConnection conn) {
        this.printVMListHeader();
        MonitoredVm[] vms = conn.getVms();
        if (vms != null) {
            for (MonitoredVm vm : vms) {
                this.listVM(vm, conn.getIndex() < 0 || vm.getBoard().getClusterIndex() == conn.getIndex(), conn.isCluster() ? conn.getId() : -1);
            }
        }
        System.out.println(VMListColumn.getBar());
    }

    public ClusterConnection selectVm(MonitoringController controller) throws IOException {
        ClusterConnection result = null;
        int pid = -1;
        ArrayList<ClusterConnection> selectableConns = new ArrayList<ClusterConnection>();
        for (MonitoredVm vm : controller.getAllMonitoredVms(true)) {
            BoardWrapper board = vm.getBoard();
            if (board.getInstanceNr() > 0) {
                selectableConns.add(new ClusterConnection(controller, board.getInstanceNr(), board.getClusterIndex()));
                continue;
            }
            selectableConns.add(new ClusterConnection(controller, board.getPid()));
        }
        if (selectableConns.size() > 0) {
            this.listVMConnections(selectableConns);
        }
        if (selectableConns.size() == 0) {
            System.out.println("No VMs running");
        } else if (selectableConns.size() > 1) {
            for (int trial = 0; trial < 3 && result == null; ++trial) {
                System.out.print("Pid => ");
                try {
                    String readInput = this.getInput().readLine();
                    if (readInput != null && readInput.length() != 0) {
                        pid = Integer.parseInt(readInput.trim());
                        for (ClusterConnection conn : selectableConns) {
                            MonitoredVm vm = conn.getVm();
                            if (vm == null || !vm.isAlive() || vm.getBoard().getPid() != pid) continue;
                            result = conn;
                            break;
                        }
                        if (result != null) continue;
                        System.out.println("No valid VM with pid " + pid);
                        continue;
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    System.out.println("Please enter valid pid");
                }
            }
        } else {
            result = (ClusterConnection)selectableConns.get(0);
        }
        return result;
    }

    public ConsoleReader getInput() {
        return this.input;
    }

    public ConsoleWriter getOutput() {
        return this.output;
    }

    public void setOutput(ConsoleWriter writer) {
        if (this.output != null && this.output.hasDumpFile()) {
            this.output.getPrintWriter().close();
        }
        this.output = writer;
    }

    public ClusterConnection getClusterConnection() {
        return this.connection;
    }

    public void setClusterConnection(ClusterConnection connection) {
        this.connection = connection;
    }

    public String[] getHistory() {
        return this.input.getHistory();
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    private static enum VMListColumn {
        COLUMN_CLUSTER_INFO("InstID/VmID", "%s %d/%d", 12),
        COLUMN_PID("Pid", "%7d", 7),
        COLUMN_CPU("CPU[ms]", "%11d", 11),
        COLUMN_VMINFO("VmTag / Java arguments / working directory", "%s", 42);

        public static final String marker = "(*)";
        private final String label;
        private final String format;
        private final int width;

        private VMListColumn(String label, String format, int width) {
            this.label = label;
            this.format = format;
            this.width = width;
        }

        public String getLabel() {
            return this.label;
        }

        public String getFormat() {
            return this.format;
        }

        public int getWidth() {
            return this.width;
        }

        public static String getBar() {
            StringBuilder sb = new StringBuilder();
            for (VMListColumn col : VMListColumn.values()) {
                sb.append('+');
                for (int i = 0; i < col.getWidth() + 2; ++i) {
                    sb.append('-');
                }
            }
            return sb.toString();
        }

        public static String getTitle() {
            StringBuilder sb = new StringBuilder();
            for (VMListColumn col : VMListColumn.values()) {
                sb.append(' ');
                sb.append(' ');
                for (int i = 0; i < col.getWidth() - col.getLabel().length(); ++i) {
                    sb.append(' ');
                }
                sb.append(col.getLabel());
                sb.append(' ');
            }
            return sb.toString();
        }

        public String getColumn(Object ... args) {
            StringBuilder sb = new StringBuilder();
            sb.append(' ');
            sb.append(' ');
            String text = null;
            int textLen = 0;
            if (args.length > 0) {
                text = String.format(this.format, args);
                textLen = text.length();
            }
            for (int i = 0; i < this.getWidth() - textLen; ++i) {
                sb.append(' ');
            }
            if (text != null) {
                sb.append(text);
            }
            sb.append(' ');
            return sb.toString();
        }
    }
}

