/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon;

import com.sap.jvm.tools.util.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public class JvmmonArgs {
    public String hostname = null;
    public int port = 1099;
    public String cmdFile = null;
    public List<String> directCommands = null;
    public int pid = -1;
    public int instanceNo = -1;
    public int clusterIndex = -1;
    public boolean startGui = false;
    public boolean printHelp = false;
    public boolean isNewJvmmon = false;
    public boolean verbose = false;
    public String traceFileName = null;

    public static JvmmonArgs parse(String[] args) throws IllegalJvmmonArgsException {
        JvmmonArgs result = new JvmmonArgs();
        int unknownOptionsFound = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-hostname")) {
                if (i + 1 < args.length) {
                    result.hostname = new String(args[++i]);
                    continue;
                }
                throw new IllegalJvmmonArgsException("-hostname option requires argument");
            }
            if (args[i].equals("-port")) {
                if (i + 1 < args.length) {
                    try {
                        result.port = Integer.parseInt(args[++i]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalJvmmonArgsException("port is not a number");
                    }
                }
                throw new IllegalJvmmonArgsException("-port option requires argument");
            }
            if (args[i].equals("-cmd")) {
                if (i + 1 < args.length) {
                    result.cmdFile = new String(args[++i]);
                    continue;
                }
                throw new IllegalJvmmonArgsException("-cmd option requires argument");
            }
            if (args[i].equals("-c")) {
                if (i + 1 < args.length) {
                    String[] cmdParts;
                    if (result.directCommands == null) {
                        result.directCommands = new ArrayList<String>();
                    }
                    String commandOrMultipleCommands = args[++i];
                    for (String commandWithArgs : cmdParts = commandOrMultipleCommands.split(";")) {
                        result.directCommands.add(commandWithArgs);
                    }
                    continue;
                }
                throw new IllegalJvmmonArgsException("-c option requires an additional argument");
            }
            if (args[i].equals("-pid")) {
                if (i + 1 < args.length) {
                    try {
                        result.pid = Integer.parseInt(args[++i]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalJvmmonArgsException("pid is not a number");
                    }
                }
                throw new IllegalJvmmonArgsException("-pid option requires argument");
            }
            if (args[i].equals("-sapSystem")) {
                if (i + 1 < args.length) {
                    try {
                        String[] parts = Tokenizer.split(args[++i], ":");
                        result.instanceNo = Integer.parseInt(parts[0]);
                        result.clusterIndex = -1;
                        if (parts.length <= 1 || parts[1].equals("*")) continue;
                        result.clusterIndex = Integer.parseInt(parts[1]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalJvmmonArgsException("sapSystem has invalid format");
                    }
                }
                throw new IllegalJvmmonArgsException("-sapSystem option requires argument");
            }
            if (args[i].equals("--new") || args[i].equals("-n")) {
                result.isNewJvmmon = true;
                continue;
            }
            if (args[i].equals("--help") || args[i].equals("-h") || args[i].equals("-?") || args[i].equals("-help")) {
                result.printHelp = true;
                break;
            }
            if (args[i].equals("--gui") || args[i].equals("-g") || args[i].equals("-gui")) {
                result.startGui = true;
                continue;
            }
            if (args[i].equals("--verbose")) {
                result.verbose = true;
                continue;
            }
            if (args[i].equals("--trace-file")) {
                if (i + 1 < args.length) {
                    result.traceFileName = args[++i];
                    continue;
                }
                throw new IllegalJvmmonArgsException("--trace-file option requires argument");
            }
            System.out.println("Unknown option: " + args[i]);
            ++unknownOptionsFound;
        }
        if (unknownOptionsFound > 0) {
            throw new IllegalJvmmonArgsException("");
        }
        return result;
    }

    private JvmmonArgs() {
    }

    public static class IllegalJvmmonArgsException
    extends Exception {
        private static final long serialVersionUID = -915372324075230421L;

        public IllegalJvmmonArgsException(String s) {
            super(s);
        }
    }
}

