/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class ChangeCommandLineFlagsCommand
extends Command {
    private CommandStringArgument flagsArg;

    public ChangeCommandLineFlagsCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_MISC_OPERATION);
        this.flagsArg = this.cmdArgs.addStringArgument("flags", false, "");
    }

    @Override
    public String getOpcode() {
        return "change command line flag";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " flags=\"<flag_1> ... <flag_n>\"";
    }

    @Override
    public String getHelpText() {
        return "Changes command line flags of a VM";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nExample:\n  change command line flag flags=-XX:+LogCompilation\n";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        String flags = this.flagsArg.getValue();
        for (MonitoredVm vm : vms) {
            vm.changeCommandLineFlags(flags);
        }
        return true;
    }
}

