/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class ClassLoaderDataGraphCommand
extends Command {
    private CommandStringArgument detail;

    public ClassLoaderDataGraphCommand(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
        this.detail = this.cmdArgs.addStringArgument("details", true, "");
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " class loader data graph";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " [details=<loaders|classes>]";
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " the class loader data graph";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        boolean includeClasses = "classes".equals(this.detail.getValue());
        boolean includeLoaders = includeClasses || "loaders".equals(this.detail.getValue());
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.getClassLoaderDataGraph(!this.localOutput(), includeLoaders, includeClasses));
        }
        return true;
    }
}

