/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class CodeBlobsCommand
extends Command {
    private CommandStringArgument flagsArg;

    public CodeBlobsCommand(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
        this.flagsArg = this.cmdArgs.addStringArgument("name", false, ".");
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " codeblobs";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " name=<method name>[!]";
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " information about code blobs with specified name";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\n<method name> may contain the wildcards '?' and '*'.\nAppend '!' to print the disassembly in addition.\n\nExamples:\n  dump codeblobs java.util.ArrayList.size()I\n  dump codeblobs java.util.HashMap.*";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        String name = this.flagsArg.getValue().trim();
        boolean showDetails = false;
        int indexOfShowDetailsMarker = name.indexOf(33);
        if (indexOfShowDetailsMarker != -1) {
            showDetails = true;
            name = name.substring(0, indexOfShowDetailsMarker);
        }
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.getCodeBlobs(!this.localOutput(), name, showDetails));
        }
        return true;
    }
}

