/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.ConnectableVm;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandArguments;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

public abstract class Command
implements Comparable<Command> {
    protected JvmMonConsole jvmMon;
    private final boolean localOutput;
    protected CommandArguments cmdArgs = new CommandArguments();
    public static final String ANSI_BLACK_ON_WHITE = "\u001b[30;47m";
    public static final String ANSI_RESET = "\u001b[0m";
    private final CommandType cmdType;

    public Command(JvmMonConsole jvmMon, CommandType type) {
        this.jvmMon = jvmMon;
        this.cmdType = type;
        this.localOutput = true;
    }

    public Command(JvmMonConsole jvmMon, CommandType type, boolean localOutput) {
        this.jvmMon = jvmMon;
        this.cmdType = type;
        this.localOutput = localOutput;
    }

    public CommandType getType() {
        return this.cmdType;
    }

    public abstract String getOpcode();

    public String getSyntax() {
        return this.getOpcode();
    }

    public abstract String getHelpText();

    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n";
    }

    public boolean execute(String[] args) throws IOException {
        try {
            this.parseArguments(args);
            boolean result = this.executeInternal(args, this.getSelectedVms());
            if (!result) {
                System.out.println(this.getOpcode() + " failed.");
            }
            return result;
        }
        catch (InvalidVmException e) {
            System.out.println(this.getOpcode() + " failed: Invalid VM handle. Is the VM still running?");
            return false;
        }
        catch (UnsupportedOperationException e) {
            System.out.println(this.getOpcode() + " failed: " + e.getMessage());
            return false;
        }
        catch (IllegalArgumentException e) {
            System.out.println(this.getOpcode() + " failed: " + e.getMessage());
            System.out.println("Usage: " + this.getDetailedHelpText());
            return false;
        }
    }

    @Override
    public int compareTo(Command o) {
        return this.getOpcode().compareTo(o.getOpcode());
    }

    public boolean isSupported() throws InvalidVmException {
        return true;
    }

    protected boolean localOutput() {
        return this.localOutput;
    }

    protected void printLegacyMonitoringOperationResult(ConnectableVm.LegacyMonitorOperationResult result) {
        this.printLegacyMonitoringOperationResult(result, false);
    }

    protected void printLegacyMonitoringOperationResult(ConnectableVm.LegacyMonitorOperationResult result, boolean highlightTrailingBlanks) {
        if (result.errorMessage != null) {
            this.printLine(result.errorMessage);
        } else if (!result.wasSupported) {
            this.printLine("Unsupported Operation.");
        } else {
            this.printLines(result.data, highlightTrailingBlanks);
        }
    }

    protected void printLines(String lines) {
        this.printLines(Arrays.asList(lines.split("[\n\r]+")), false);
    }

    protected void printLines(String lines, boolean highlightTrailingBlanks) {
        this.printLines(Arrays.asList(lines.split("[\n\r]+")), highlightTrailingBlanks);
    }

    protected void printLines(List<String> lines) {
        this.printLines(lines, false);
    }

    protected void printLines(List<String> lines, boolean highlightTrailingBlanks) {
        if (lines != null) {
            PrintWriter writer = this.jvmMon.getOutput().getPrintWriter();
            boolean dumpFile = this.jvmMon.getOutput().hasDumpFile();
            boolean isRealConsole = this.jvmMon.getOutput().isANSIConsole();
            if (dumpFile) {
                writer.println();
                writer.println("Result of " + this.getOpcode() + ":");
            }
            if (!highlightTrailingBlanks || !isRealConsole) {
                for (String line : lines) {
                    writer.println(line);
                }
            } else {
                for (String line : lines) {
                    if (line == null) continue;
                    int indexOfLastTrailingBlank = -1;
                    int lastIndex = line.length();
                    while (lastIndex > 0 && line.charAt(lastIndex - 1) == ' ') {
                        indexOfLastTrailingBlank = lastIndex-- - 1;
                    }
                    if (indexOfLastTrailingBlank == -1) {
                        writer.println(line);
                        continue;
                    }
                    writer.println(line.substring(0, indexOfLastTrailingBlank) + ANSI_BLACK_ON_WHITE + line.substring(indexOfLastTrailingBlank) + ANSI_RESET);
                }
            }
            writer.flush();
            if (dumpFile) {
                String absoluteFilename = new File(this.jvmMon.getOutput().getDumpFileName()).getAbsolutePath();
                System.out.println("-- printed to local file " + absoluteFilename);
            }
        } else {
            throw new UnsupportedOperationException("Got no operation result");
        }
    }

    protected void printLine(String line) {
        if (line != null) {
            PrintWriter writer = this.jvmMon.getOutput().getPrintWriter();
            boolean dumpFile = this.jvmMon.getOutput().hasDumpFile();
            if (dumpFile) {
                writer.println();
                writer.println("Result of " + this.getOpcode() + ":");
            }
            writer.println(line);
            writer.flush();
            if (dumpFile) {
                String absoluteFilename = new File(this.jvmMon.getOutput().getDumpFileName()).getAbsolutePath();
                System.out.println("-- printed to local file " + absoluteFilename);
            }
        } else {
            throw new UnsupportedOperationException("Got no operation result");
        }
    }

    protected void printVMHeader(MonitoredVm vm) {
        BoardWrapper board = vm.getBoard();
        PrintWriter writer = this.jvmMon.getOutput().getPrintWriter();
        writer.println();
        int instanceNr = board.getInstanceNr();
        StringBuilder header = new StringBuilder("VM with pid ");
        header.append(board.getPid());
        if (instanceNr >= 0) {
            header.append(" (Instance number " + instanceNr + ", VM index " + board.getVmIndex() + ")");
        }
        header.append(":");
        writer.println(header);
        for (int i = 0; i < header.length(); ++i) {
            header.replace(i, i + 1, "-");
        }
        writer.println(header);
        writer.flush();
    }

    protected void parseArguments(String[] args) throws IllegalArgumentException {
        this.cmdArgs.parse(args, this.jvmMon.getInput());
    }

    protected abstract boolean executeInternal(String[] var1, MonitoredVm[] var2) throws InvalidVmException, IOException;

    protected MonitoredVm[] getVms() {
        return this.jvmMon.getClusterConnection().getVms();
    }

    protected MonitoredVm getVm() {
        return this.jvmMon.getClusterConnection().getVm();
    }

    protected MonitoredVm[] getSelectedVms() {
        return this.jvmMon.getClusterConnection().getSelectedVms();
    }

    public static enum CommandType {
        VM_PRINT_OPERATION(0, "VmPrintOperation", "Print commands"),
        VM_DUMP_OPERATION(1, "VmDumpOperation", "Dump commands"),
        VM_ADMINISTRATION(2, "VmAdministration", "Admin commands"),
        VM_GC_OPERATION(3, "VmGCOperation", "GC commands"),
        VM_JIT_OPERATION(4, "VmJITOperation", "JIT commands"),
        VM_MISC_OPERATION(5, "VmMiscOperation", "VM commands"),
        VM_CLUSTER_OPERATION(6, "VmCClusterOperation", "VM selection commands"),
        JVMMON_OPERATION(7, "JvmmonOperation", "Jvmmon commands");

        public final int id;
        public final String name;
        public final String helpText;

        private CommandType(int id, String name, String helpText) {
            this.id = id;
            this.name = name;
            this.helpText = helpText;
        }
    }
}

