/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;

public class CrashVmCommand
extends Command {
    public CrashVmCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_MISC_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "crash vm";
    }

    @Override
    public String getHelpText() {
        return "Crashes a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        boolean crash = false;
        if (this.jvmMon.getInput() != null) {
            if (vms.length > 1) {
                System.out.print("Do you really want to crash all selected VMs (1 = yes, 0 = no)? => ");
            } else {
                System.out.print("Do you really want to crash the selected VM (1 = yes, 0 = no)? => ");
            }
            crash = this.jvmMon.getInput().readLine().equals("1");
        }
        if (crash) {
            for (MonitoredVm vm : vms) {
                vm.crashVm();
            }
        }
        return crash;
    }
}

