/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;

public class DeoptimizeAllCommand
extends Command {
    public DeoptimizeAllCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_JIT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "deoptimizeall";
    }

    @Override
    public String getHelpText() {
        return "Deoptimizes all methods";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.deoptimizeAllMethods());
        }
        return true;
    }
}

