/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class DeoptimizeMethodCommand
extends Command {
    private CommandStringArgument flagsArg;

    public DeoptimizeMethodCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_JIT_OPERATION);
        this.flagsArg = this.cmdArgs.addStringArgument("method", false, ".");
    }

    @Override
    public String getOpcode() {
        return "deoptimize";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " method=<part of method name>";
    }

    @Override
    public String getHelpText() {
        return "Deoptimizes all activations of the specified method(s)";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        String methodString = this.flagsArg.getValue();
        methodString = methodString.trim();
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.deoptimizeMethod(methodString));
        }
        return true;
    }
}

