/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;

public class DetailedClassStatisticCommand
extends Command {
    public DetailedClassStatisticCommand(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " detailed class statistic";
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " detailed class statistics of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.getClassStatistic(!this.localOutput(), true));
        }
        return true;
    }
}

