/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class DumpHeapCommand
extends Command {
    private CommandStringArgument doGcArg;
    private CommandStringArgument infoArg;

    public DumpHeapCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_DUMP_OPERATION);
        this.doGcArg = this.cmdArgs.addStringArgument("doGC", true, "true");
        this.infoArg = this.cmdArgs.addStringArgument("info", true, "");
    }

    @Override
    public String getOpcode() {
        return "dump heap";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " doGC=<true/false> info=<info>";
    }

    @Override
    public String getHelpText() {
        return "Dumps the heap of a VM";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nFunction syntax\n\n  dump heap\n        doGC=<true/false>\n        info=<info text>\n  doGC: shall a full GC be done before dumping the heap? Default is true.\n  info: specify a custom String to be added to the dump. Default is empty.\n";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        boolean doGC = Boolean.parseBoolean(this.doGcArg.getValue());
        String info = this.infoArg.getValue();
        for (MonitoredVm vm : vms) {
            vm.dumpHeap(doGC, info);
        }
        return true;
    }
}

