/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class DumpStackTraceWithInfoCommand
extends Command {
    private CommandStringArgument infoArg;

    public DumpStackTraceWithInfoCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_DUMP_OPERATION);
        this.infoArg = this.cmdArgs.addStringArgument("info", false, "");
    }

    @Override
    public String getOpcode() {
        return "dump stacktrace with info";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " info=<info>";
    }

    @Override
    public String getHelpText() {
        return "Dumps the stacks of all threads with additional information";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        String info = this.infoArg.getValue();
        for (MonitoredVm vm : vms) {
            vm.getStackTrace(true, true, info);
        }
        return true;
    }
}

