/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.ConnectableVm;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;

public class ExitVmCommand
extends Command {
    public ExitVmCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_MISC_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "exit vm";
    }

    @Override
    public String getHelpText() {
        return "Exits a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        boolean exit = false;
        if (this.jvmMon.getInput() != null) {
            if (vms.length > 1) {
                System.out.print("Do you really want to exit all selected VMs (1 = yes, 0 = no)? => ");
            } else {
                System.out.print("Do you really want to exit the selected VM (1 = yes, 0 = no)? => ");
            }
            exit = this.jvmMon.getInput().readLine().equals("1");
        }
        if (exit) {
            for (MonitoredVm vm : vms) {
                vm.exitVm(1, ConnectableVm.ExitType.FORCED_OS);
            }
        }
        return exit;
    }
}

