/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandIntegerArgument;
import java.io.IOException;

public class FlightrecorderCommand
extends Command {
    private CommandIntegerArgument numArg;

    public FlightrecorderCommand(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
        this.numArg = this.cmdArgs.addIntegerArgument("num", true, 50);
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " flight recorder";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " [num=<numLastEntries>]";
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " part of the flight recorder of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        int numLastEntries = this.numArg.getValue();
        if (numLastEntries > 0) {
            for (MonitoredVm vm : vms) {
                if (vms.length > 1) {
                    this.printVMHeader(vm);
                }
                this.printLegacyMonitoringOperationResult(vm.getFlightRecorder(!this.localOutput(), numLastEntries));
            }
        }
        return true;
    }
}

