/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class ForceCompileCommand
extends Command {
    private CommandStringArgument flagsArg;

    public ForceCompileCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_JIT_OPERATION);
        this.flagsArg = this.cmdArgs.addStringArgument("method", false, ".");
    }

    @Override
    public String getOpcode() {
        return "compile";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " method=<part of method name>[!]";
    }

    @Override
    public String getHelpText() {
        return "Forces compilation of the specified method(s)";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nBy <method_name> you specify a substring of the name and signature of\nthe methods that get compiled.\nAppend '!' in order to execute a blocking compile job.\n\nExample:\n  compile java.lang.Short.shortValue()S";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        String methodString = this.flagsArg.getValue().trim();
        boolean blocking = false;
        int indexOfBlockingMarker = methodString.indexOf(33);
        if (indexOfBlockingMarker != -1) {
            blocking = true;
            methodString = methodString.substring(0, indexOfBlockingMarker);
        }
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.forceCompile(methodString, blocking, true));
        }
        return true;
    }
}

