/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class ForceOSRCompileCommand
extends Command {
    private CommandStringArgument flagsArg;

    public ForceOSRCompileCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_JIT_OPERATION);
        this.flagsArg = this.cmdArgs.addStringArgument("method", false, ".");
    }

    @Override
    public String getOpcode() {
        return "osrcompile";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " method='method@bci'";
    }

    @Override
    public String getHelpText() {
        return "Forces osr compilation of the specified method";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        int bci;
        String methodString = this.flagsArg.getValue().trim();
        String bciString = "";
        int indexOfAt = methodString.indexOf(64);
        if (indexOfAt == -1) {
            this.printLine("Required format 'method@bci' / no '@' character found");
            return false;
        }
        bciString = methodString.substring(indexOfAt + 1);
        if (bciString.length() == 0) {
            this.printLine("Required format 'method@bci' / no branch bci found");
            return false;
        }
        try {
            bci = Integer.valueOf(bciString);
        }
        catch (NumberFormatException e) {
            this.printLine("Required format 'method@bci' / bci branch must be numerical");
            return false;
        }
        if (bci < 1) {
            this.printLine("Required format 'method@bci' / branch bci needs to be a positive integer");
            return false;
        }
        methodString = methodString.substring(0, indexOfAt);
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.forceOsrCompile(methodString, bci));
        }
        return true;
    }
}

