/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.util.ArrayList;
import java.util.List;

public class HelpCommand
extends Command {
    public HelpCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.JVMMON_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "help";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " [<command>]";
    }

    @Override
    public String getHelpText() {
        return "Shows the help text";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) {
        List<Command> commands = this.jvmMon.getCommands();
        if (args.length == 0) {
            int maxLen = 0;
            for (Command cmd : commands) {
                maxLen = Math.max(maxLen, cmd.getOpcode().length());
            }
            String formatString = "  %-" + maxLen + "s - %s\n";
            String formatStringMulti = "  %-" + maxLen + "s   %s\n";
            String formatStringHeader = "%." + Math.max(maxLen + 2, 30) + "s\n";
            List[] cmdsClassified = new List[Command.CommandType.values().length];
            for (Command cmd : commands) {
                Command.CommandType cmdType = cmd.getType();
                ArrayList<Command> typeClass = cmdsClassified[cmdType.id];
                if (typeClass == null) {
                    cmdsClassified[cmdType.id] = typeClass = new ArrayList<Command>();
                }
                typeClass.add(cmd);
            }
            System.out.println();
            for (Command.CommandType cmdType : Command.CommandType.values()) {
                List typeClass = cmdsClassified[cmdType.id];
                if (typeClass == null || typeClass.size() <= 0) continue;
                System.out.println();
                String header = "__ " + cmdType.helpText + ": ______________________________________________________________";
                System.out.printf(formatStringHeader, header);
                System.out.println();
                for (Command cmd : typeClass) {
                    String[] helpText = cmd.getHelpText().split("\n");
                    System.out.printf(formatString, cmd.getOpcode(), helpText[0]);
                    for (int i = 1; i < helpText.length; ++i) {
                        System.out.printf(formatStringMulti, "", helpText[i]);
                    }
                }
            }
            System.out.printf(formatString, "help \"<command>\"", "Displays detailed help about the specified command");
            System.out.printf(formatString, "!", "Repeats the last command");
            System.out.printf(formatString, "!!", "Repeats the last command");
            System.out.printf(formatString, "!N", "Repeats command with number N in history");
            System.out.printf(formatString, "!TEXT", "Repeats command that started with TEXT");
        } else {
            String command_opcode = "";
            for (int i = 0; i < args.length; ++i) {
                command_opcode = command_opcode + args[i];
                if (i >= args.length - 1) continue;
                command_opcode = command_opcode + " ";
            }
            String indent = "  ";
            for (int i = 0; i < commands.size(); ++i) {
                if (!commands.get(i).getOpcode().startsWith(command_opcode)) continue;
                Command cmd = commands.get(i);
                System.out.println();
                System.out.println("COMMAND");
                System.out.println("  " + cmd.getOpcode());
                System.out.println();
                System.out.println("SYNTAX");
                System.out.println("  " + cmd.getSyntax());
                System.out.println();
                System.out.println("DETAILS");
                String[] helpText = cmd.getDetailedHelpText().split("\n");
                for (int j = 0; j < helpText.length; ++j) {
                    System.out.println("  " + helpText[j]);
                }
                System.out.println();
            }
        }
        return true;
    }
}

