/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;

public class HistoryCommand
extends Command {
    private static String getPaddedNumber(int number, int length) {
        String numberString = String.valueOf(number);
        String padding = "";
        for (int k = numberString.length(); k < length; ++k) {
            padding = padding + " ";
        }
        return padding + numberString;
    }

    public HistoryCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.JVMMON_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "history";
    }

    @Override
    public String getHelpText() {
        return "Shows a list of the commands executed";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) {
        System.out.println("History:");
        String[] history = this.jvmMon.getHistory();
        for (int i = 0; i < history.length; ++i) {
            String element = history[i];
            System.out.println(HistoryCommand.getPaddedNumber(i, 4) + ": " + element);
        }
        return true;
    }
}

