/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class JITInformationCommand
extends Command {
    private CommandStringArgument function;
    private CommandStringArgument detail;
    private CommandStringArgument granule;

    public JITInformationCommand(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
        this.function = this.cmdArgs.addStringArgument("function", true, "summary");
        this.detail = this.cmdArgs.addStringArgument("detail", true, "all");
        this.granule = this.cmdArgs.addStringArgument("granule", true, "4096");
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " jit info";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " [function={summary|CodeCache}] [detail=<detail>] [granule=<granularity>]";
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " information about JIT compiler and code cache";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nFunction syntax\n\n  print jit info\n        function={summary|CodeCache}\n        detail={<detail>}\n        granule={<granularity>}\n\n  function=summary\n    prints some summary information about the state of the\n    CodeCache and the JIT compiler. The detail and granule\n    parameters are ignored.\n\n  function=CodeCache\n    analyzes and prints detailed information about the CodeCache.\n    The detail and granule parameters control which information\n    is printed in what detail.\n\n  <detail> is one of\n    all         - all of the below, in that order.\n                  This is the default. Prints a lot!!\n    aggregate   - Examine the CodeHeap and remember the data in local\n                  structures. Must be run before any other subfunction\n                  can be requested.\n                  In older SAPJVMs this parameter was named \"analyze\".\n    UsedSpace   - print used space information (a list of the largest code blocks).\n    FreeSpace   - print free space information.\n    MethodCount - print method count information.\n    MethodSpace - print method space information.\n    MethodAge   - print age information, compilationID based, nMethods only.\n    MethodNames - print name information, includes signature where available.\n    discard     - free all resources allocated by this function.\n                  Helps keep memory footprint low.\n\n  <granularity>\n    specifies the amount of storage space one aggregation element (one granule)\n    represents. It is evaluated for the \"analyze\" subfunction only.\n    Since the \"all\" subfunction implies \"analyze\", it also accepts this parameter.\n    The granularity cannot be smaller than the segment size of the CodeCache.\n    On the other hand, it should be smaller than 1/256 of the used CodeCache\n    space to provide meaningful output. The default value is 4096 bytes.\n";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws InvalidVmException, IOException {
        String arg1 = this.function.getValue().trim();
        String arg2 = this.detail.getValue().trim();
        String arg3 = this.granule.getValue().trim();
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.getJITInformation(!this.localOutput(), arg1, arg2, arg3));
        }
        return true;
    }
}

