/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class PrintClusterMemoryInformationCommand
extends Command {
    public PrintClusterMemoryInformationCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_PRINT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "print cluster memory information";
    }

    @Override
    public String getHelpText() {
        return "Prints information about the memory consumption of the cluster";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws InvalidVmException, IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Map info = vms[0].getClusterMemoryInformation();
        lines.add(String.format("Shared Pool: %.2f MB", (double)((Long)info.get("SHARED_POOL_SIZE")).longValue() / 1048576.0));
        lines.add(String.format("Total: %.2f MB (Allocated %.2f MB, Peak %.2f MB)", (double)((Long)info.get("SHARED_MEMORY_CONSUMPTION")).longValue() / 1048576.0, (double)((Long)info.get("SHARED_MEMORY_ALLOCATION")).longValue() / 1048576.0, (double)((Long)info.get("SHARED_MEMORY_PEAK")).longValue() / 1048576.0));
        lines.add("");
        this.printLines(lines);
        return true;
    }
}

