/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;
import java.util.ArrayList;

public class PrintDebuggingInformationCommand
extends Command {
    public PrintDebuggingInformationCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_PRINT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "print debugging information";
    }

    @Override
    public String getHelpText() {
        return "Prints information about the debugging state of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            ArrayList<String> lines = new ArrayList<String>();
            BoardWrapper board = vm.getBoard();
            lines.add("State : " + board.getDebugOnDemandState().getDescription());
            lines.add("Port  : " + board.getDebugPort());
            lines.add("Client: " + board.getDebugClient());
            if (board.isDebugLocalOnly()) {
                lines.add("Only locally accessible");
            } else {
                lines.add("Globally accessible");
            }
            this.printLines(lines);
        }
        return true;
    }
}

