/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class PrintMetaspaceStatisticsCommand
extends Command {
    CommandStringArgument typeArg;

    public PrintMetaspaceStatisticsCommand(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
        this.typeArg = this.cmdArgs.addStringArgument("type", true, "non-class");
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " metaspace";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " [type=<class/non-class>]";
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " metaspace statistics";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nThe default type is non-class.\n";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        String type = this.typeArg.getValue();
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.getMetaspaceStat(type, !this.localOutput()));
        }
        return true;
    }
}

