/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.ConnectableVm;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;
import java.util.ArrayList;

public class PrintTraceFlagsCommand
extends Command {
    public PrintTraceFlagsCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_PRINT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "print trace flags";
    }

    @Override
    public String getHelpText() {
        return "Prints the active trace flags of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            ConnectableVm.TraceFlagSpec[] traceFlagsSet;
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            int enabled = 0;
            ArrayList<String> lines = new ArrayList<String>();
            for (ConnectableVm.TraceFlagSpec flag : traceFlagsSet = vm.getTraceFlags()) {
                if (!flag.enabled) continue;
                lines.add("Active trace flag " + flag);
                ++enabled;
            }
            if (enabled > 0) {
                this.printLines(lines);
                continue;
            }
            System.out.println("No active trace flag");
        }
        return true;
    }
}

