/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.internals.VmInternals;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PrintVirtualizationInfoCommand
extends Command {
    private static final String VirtualizationPlatform = "VirtualizationPlatform";

    public PrintVirtualizationInfoCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_PRINT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "print virtualization info";
    }

    @Override
    public String getHelpText() {
        return "Prints the platform virtualization info";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nThe target VM must run with command line switches -Xjvmx\nor -XX:+VirtualPlatformDetection";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            Map info = vm.getVirtualizationInfo();
            this.printLine("Platform virtualization:");
            if (info.size() == 0) {
                this.printLine("No virtualization information");
                return true;
            }
            String[] keys = info.keySet().toArray(new String[info.size()]);
            Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);
            for (String actString : keys) {
                this.printLine(actString + "=" + (String)info.get(actString));
            }
        }
        return true;
    }

    public static List<String> getResultAsText(VmInternals vmInt) {
        ArrayList<String> result = new ArrayList<String>();
        Properties props = vmInt.getVirtualizationInfo();
        int maxKeyLength = 0;
        for (Object actKey : props.keySet()) {
            int l = actKey.toString().length();
            if (l <= maxKeyLength) continue;
            maxKeyLength = l;
        }
        ++maxKeyLength;
        if (props.size() > 0) {
            ArrayList<String> sorted = new ArrayList<String>(props.stringPropertyNames());
            Collections.sort(sorted);
            for (String key : sorted) {
                StringBuffer sb = new StringBuffer(60);
                sb.append(key);
                int lengthDiff = maxKeyLength - key.length();
                for (int i = 0; i < sb.capacity() && i < lengthDiff; ++i) {
                    sb.append(' ');
                }
                sb.append(": ");
                sb.append(props.getProperty(key));
                if (key.equals(VirtualizationPlatform)) {
                    result.add(0, sb.toString());
                    continue;
                }
                result.add(sb.toString());
            }
        } else {
            result.add("No virtualization information available.");
        }
        result.add(0, "Platform virtualization:");
        return result;
    }
}

