/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;

public class PrintVmCompressedClassSpaceDetails
extends Command {
    public PrintVmCompressedClassSpaceDetails(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " vm compressed class space information";
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " information about the compressed class space of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws InvalidVmException, IOException {
        for (MonitoredVm vm : vms) {
            BoardWrapper board = vm.getBoard();
            boolean hasMetaspace = board.getBoolean("USES_METASPACE", false);
            boolean hasCompressedClassPointers = board.getBoolean("USES_COMPRESSED_CLASS_POINTERS", false);
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            if (hasMetaspace) {
                if (hasCompressedClassPointers) {
                    this.printLegacyMonitoringOperationResult(vm.getCompressedClassSpaceDetails(!this.localOutput()));
                    continue;
                }
                this.printLines("Metaspace is not using compressed class space");
                continue;
            }
            this.printLines("No metaspace found in the monitored VM");
        }
        return true;
    }
}

