/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;
import java.util.ArrayList;

public class PrintVmInformationCommand
extends Command {
    public PrintVmInformationCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_PRINT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "print vm information";
    }

    @Override
    public String getHelpText() {
        return "Prints information about a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            ArrayList<String> lines = new ArrayList<String>();
            BoardWrapper board = vm.getBoard();
            lines.add("VM Version       : " + board.getVmVersion());
            lines.add("Working directory: " + board.getWorkingDirectory());
            StringBuilder vmFlags = new StringBuilder("Vm Flags         : ");
            String[] s = board.getVmFlags();
            for (int i = 0; i < s.length; ++i) {
                vmFlags.append(s[i] + " ");
            }
            lines.add(vmFlags.toString());
            StringBuilder vmArguments = new StringBuilder("Vm Arguments     : ");
            s = board.getVmArguments();
            for (int i = 0; i < s.length; ++i) {
                vmArguments.append(s[i] + " ");
            }
            lines.add(vmArguments.toString());
            lines.add("Java Arguments   : " + board.getJavaArgumentLine());
            this.printLines(lines);
        }
        return true;
    }
}

