/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;
import java.util.ArrayList;

public class PrintVmMemoryInformationCommand
extends Command {
    public PrintVmMemoryInformationCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_PRINT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "print vm memory information";
    }

    @Override
    public String getHelpText() {
        return "Prints information about the memory consumption of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            ArrayList<String> lines = new ArrayList<String>();
            BoardWrapper board = vm.getBoard();
            boolean hasMetaspace = board.getBoolean("USES_METASPACE", false);
            boolean hasCompressedClassPointers = board.getBoolean("USES_COMPRESSED_CLASS_POINTERS", false);
            if (vms.length > 1) {
                lines.add("VM index: " + board.getVmIndex());
            }
            lines.add(String.format("committed java heap: %.2f MB", (double)board.getCommittedHeapSizeAfterLastGc() / 1048576.0));
            lines.add(String.format(hasMetaspace ? "committed metaspace: %.2f MB" : "committed perm. gen.: %.2f MB", (double)board.getCommittedPermSizeAfterLastGc() / 1048576.0));
            lines.add(String.format(hasMetaspace ? "used metaspace: %.2f MB" : "used perm. gen.: %.2f MB", (double)board.getUsedPermSizeAfterLastGc() / 1048576.0));
            if (hasMetaspace) {
                if (hasCompressedClassPointers) {
                    lines.add(String.format("compressed class space maximum size: %.2f MB", (double)board.getCompressedClassSpaceSize() / 1048576.0));
                    lines.add(String.format("compressed class space committed size at the end of last gc: %.2f MB", (double)board.getCompressedClassSpaceCommitted() / 1048576.0));
                    lines.add(String.format("compressed class space used size at the end of last gc: %.2f MB", (double)board.getCompressedClassSpaceUsed() / 1048576.0));
                } else {
                    lines.add("No compressed class pointers used.");
                }
            }
            lines.add(String.format("committed code cache: %.2f MB", (double)board.getCommittedCodeCacheSize() / 1048576.0));
            lines.add("");
            this.printLines(lines);
        }
        return true;
    }
}

