/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.board.BoardWrapper;
import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.Formatter;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;
import java.util.ArrayList;

public class PrintVmPerformanceInformationCommand
extends Command {
    public PrintVmPerformanceInformationCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_PRINT_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "print performance information";
    }

    @Override
    public String getHelpText() {
        return "Prints information about the performance of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        for (MonitoredVm vm : vms) {
            ArrayList<String> lines = new ArrayList<String>();
            BoardWrapper board = vm.getBoard();
            lines.add("VM with index " + board.getVmIndex() + ": \n");
            lines.add(String.format("CPU time            : %8s", Formatter.formatTimeMsInElements(board.getCpuTime() / 1000L)));
            lines.add(String.format("processing time     : %8s", Formatter.formatTimeMsInElements(board.getElapsedTime() / 1000L)));
            lines.add(String.format("number of GCs       : %8d", board.getNrOfGcs()));
            lines.add(String.format("number of full GCs  : %8d", board.getNrOfFullGcs()));
            this.printLines(lines);
        }
        return true;
    }
}

