/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class RetrieveGcHistoryCommand
extends Command {
    private CommandStringArgument file;

    public RetrieveGcHistoryCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_GC_OPERATION);
        this.file = this.cmdArgs.addStringArgument("file", true, "sapjvm_gc.prf");
    }

    @Override
    public String getOpcode() {
        return "retrieve complete gc history";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " file=<filename>";
    }

    @Override
    public String getHelpText() {
        return "Retrieves the complete GC history of a VM into a local file";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        String fileName = this.file.getValue();
        if (fileName.trim().length() == 0) {
            throw new IllegalArgumentException("Empty file name not allowed.");
        }
        boolean multipleFiles = vms.length > 1;
        for (MonitoredVm vm : vms) {
            String gcFileName;
            if (multipleFiles) {
                StringBuilder sb = new StringBuilder(fileName);
                int pid = vm.getBoard().getPid();
                int suffixPos = fileName.lastIndexOf(46);
                if (suffixPos >= 0 && suffixPos < sb.length()) {
                    sb.insert(suffixPos, "_" + pid);
                } else {
                    sb.append("_" + pid);
                }
                gcFileName = sb.toString();
            } else {
                gcFileName = fileName;
            }
            File f = new File(gcFileName);
            if (!f.exists() && !f.createNewFile() || !f.canWrite()) {
                throw new IllegalArgumentException("File " + gcFileName + " cannot be written.");
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
            bos.write(vm.retrieveGcHistory());
            bos.close();
            System.out.println("-- dumped to local file " + gcFileName);
        }
        return true;
    }
}

