/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.ClusterConnection;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandIntegerArgument;
import java.io.IOException;

public class SelectVmCommand
extends Command {
    private final boolean allCmd;
    private CommandIntegerArgument vmIdArg;

    public SelectVmCommand(JvmMonConsole jvmMon, boolean allCmd) {
        super(jvmMon, Command.CommandType.VM_CLUSTER_OPERATION);
        this.allCmd = allCmd;
        if (!allCmd) {
            this.vmIdArg = this.cmdArgs.addIntegerArgument("vmId", true, 0);
        }
    }

    @Override
    public String getOpcode() {
        return this.allCmd ? "select vm all" : "select vm";
    }

    @Override
    public String getSyntax() {
        return this.allCmd ? this.getOpcode() : this.getOpcode() + " [vmId=<index>]";
    }

    @Override
    public String getHelpText() {
        return this.allCmd ? "Selects all VMs (in the cluster)" : "Selects a VM (in the cluster)";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        ClusterConnection curConnection = this.jvmMon.getClusterConnection();
        String[] usedArgs = args;
        String errorReason = "unknown";
        if (!this.allCmd) {
            if (usedArgs.length == 0 && this.jvmMon.getInput() != null) {
                ClusterConnection newConnection = this.jvmMon.selectVm(curConnection.getMonitoringController());
                if (newConnection != null && this.jvmMon.switchToClusterConnection(newConnection)) {
                    return true;
                }
            } else if (!this.jvmMon.getClusterConnection().isCluster()) {
                errorReason = "jvmmon is not attached to a cluster";
            } else {
                int clusterIndex = this.vmIdArg.getValue();
                ClusterConnection newConnection = new ClusterConnection(curConnection.getMonitoringController(), curConnection.getId(), clusterIndex);
                if (this.jvmMon.switchToClusterConnection(newConnection)) {
                    return true;
                }
                errorReason = "parameter 'index' missing or invalid";
            }
        } else if (!this.jvmMon.getClusterConnection().isCluster()) {
            errorReason = "jvmmon is not attached to a cluster";
        } else {
            ClusterConnection newConnection = new ClusterConnection(curConnection.getMonitoringController(), curConnection.getId(), -1);
            if (this.jvmMon.switchToClusterConnection(newConnection)) {
                return true;
            }
        }
        System.err.println(this.getOpcode() + " failed: " + errorReason);
        return false;
    }

    @Override
    protected void parseArguments(String[] args) throws IllegalArgumentException {
        if (args.length > 0 || this.jvmMon.getInput() == null) {
            this.cmdArgs.parse(args, this.jvmMon.getInput());
        }
    }
}

