/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import java.io.IOException;

public class SetDebuggingPortCommand
extends Command {
    public SetDebuggingPortCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_MISC_OPERATION);
    }

    @Override
    public String getOpcode() {
        return "set debugging port";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " <port>[-<toPort>]";
    }

    @Override
    public String getHelpText() {
        return "Sets the debugging port of a VM";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nThis command works similar to \"set debugging port range\", however a single port or a port range can simply be added as argument to the command.\n\nExamples:\n  set debugging port 8000\n  set debugging port 8000-8010\n";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        int toPort;
        int fromPort;
        String argsToPort;
        String argsFromPort;
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            argBuilder.append(args[i].trim());
        }
        String argStr = argBuilder.toString();
        if (argStr.isEmpty()) {
            throw new IllegalArgumentException("Unknown argument " + argStr);
        }
        int separatorIdx = argStr.indexOf("-");
        if (separatorIdx < 0) {
            argsFromPort = argStr;
            argsToPort = argStr;
        } else {
            argsFromPort = argStr.substring(0, separatorIdx);
            argsToPort = argStr.substring(separatorIdx + 1, argStr.length());
        }
        try {
            fromPort = Integer.parseInt(argsFromPort);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Argument value for fromPort is not a number: '" + argsFromPort + "'");
        }
        try {
            toPort = Integer.parseInt(argsToPort);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("wrong argument value for toPort: '" + argsToPort + "'");
        }
        if (fromPort < 0) {
            throw new IllegalArgumentException("'fromPort' is not valid. Negative values are not allowed (parsed " + fromPort + ").");
        }
        if (toPort < 0) {
            throw new IllegalArgumentException("'toPort' is not valid. Negative values are not allowed (parsed " + toPort + ").");
        }
        if (fromPort > toPort) {
            throw new IllegalArgumentException("The port range is not valid. 'toPort'(" + toPort + ") must be greater than 'fromPort'(" + fromPort + ").");
        }
        for (MonitoredVm vm : vms) {
            vm.setDefaultDebuggingPortRange(fromPort, toPort);
        }
        return true;
    }
}

