/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandIntegerArgument;
import java.io.IOException;

public class SetDebuggingPortRangeCommand
extends Command {
    private CommandIntegerArgument fromPortArg;
    private CommandIntegerArgument toPortArg;

    public SetDebuggingPortRangeCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_MISC_OPERATION);
        this.fromPortArg = this.cmdArgs.addIntegerArgument("fromPort", false, -1);
        this.toPortArg = this.cmdArgs.addIntegerArgument("toPort", false, -1);
    }

    @Override
    public String getOpcode() {
        return "set debugging port range";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " fromPort=<port> toPort=<port>";
    }

    @Override
    public String getHelpText() {
        return "Sets the debugging port range of a VM";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nWhen debugging gets enabled on the VM, e.g. by the jvmmon command \"start debugging\", a port out of the specified range is chosen.\nThe JVM usually tries to bind the debugging server to the lowest port in the range.\nIf this fails it will try on the next higher port number.\n\nExamples:\n  set debugging port range fromPort=8000 toPort=8000\n  set debugging port range fromPort=8000 toPort=8010\n";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        int fromPort = this.fromPortArg.getValue();
        int toPort = this.toPortArg.getValue();
        if (fromPort < 0) {
            throw new IllegalArgumentException("'fromPort' is not valid. Negative values are not allowed (parsed " + fromPort + ").");
        }
        if (toPort < 0) {
            throw new IllegalArgumentException("'toPort' is not valid. Negative values are not allowed (parsed " + toPort + ").");
        }
        if (fromPort > toPort) {
            throw new IllegalArgumentException("The port range is not valid. 'toPort'(" + toPort + ") must be greater than 'fromPort'(" + fromPort + ").");
        }
        for (MonitoredVm vm : vms) {
            vm.setDefaultDebuggingPortRange(fromPort, toPort);
        }
        return true;
    }
}

