/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.console.ConsoleWriter;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SetDumpFileCommand
extends Command {
    private CommandStringArgument fileArg;
    private CommandStringArgument modeArg;
    private boolean console;
    private static final ConsoleWriter CONSOLE_WRITER = new ConsoleWriter(System.out);

    public SetDumpFileCommand(JvmMonConsole jvmMon, boolean console) {
        super(jvmMon, Command.CommandType.JVMMON_OPERATION);
        this.console = console;
        if (!console) {
            this.fileArg = this.cmdArgs.addStringArgument("file", false, "dump.txt");
            this.modeArg = this.cmdArgs.addStringArgument("mode", true, "append");
        }
    }

    @Override
    public String getOpcode() {
        return this.console ? "print to console" : "print to file";
    }

    @Override
    public String getSyntax() {
        return this.console ? this.getOpcode() : this.getOpcode() + " file=<filename> [mode=<append|overwrite>]";
    }

    @Override
    public String getHelpText() {
        return this.console ? "Redirect print commands to console output" : "Redirect print commands to local file";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        boolean append;
        if (this.console) {
            this.jvmMon.setOutput(CONSOLE_WRITER);
            return true;
        }
        String fileName = this.fileArg.getValue();
        boolean bl = append = !this.modeArg.getValue().equals("overwrite");
        if (fileName == null) {
            this.jvmMon.setOutput(CONSOLE_WRITER);
        } else {
            try {
                this.jvmMon.setOutput(new ConsoleWriter(fileName, append));
            }
            catch (FileNotFoundException e) {
                System.out.println("Couldn't open print file " + fileName);
                return false;
            }
        }
        return true;
    }
}

