/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;
import java.util.ArrayList;

public class SetTraceFlagsCommand
extends Command {
    private CommandStringArgument flagsArg;

    public SetTraceFlagsCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_MISC_OPERATION);
        this.flagsArg = this.cmdArgs.addStringArgument("flags", true, "");
    }

    @Override
    public String getOpcode() {
        return "set trace flags";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " flags=\"<flag name or number> <flag name or number> ...\"";
    }

    @Override
    public String getHelpText() {
        return "Sets trace flags in the target VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder sb = new StringBuilder(this.getHelpText() + ".\n\nFunction syntax\n\n  set trace flags\n      flags=\"<whitespace separated list of flag numbers>\"\n\nIf parameter \"flags\" isn't specified, an interactive prompt for trace flags is started.\nAll currently active trace flags will be cleared.\n\nExample:\n  set trace flags flags=\"-XtraceJdkInternals\"\nor\n  set trace flags flags=\"JdkInternals\"\nor\n  set trace flags flags=\"180\"\n\nThis will activate the JDK internals trace, corresponding to trace flag -XtraceJdkInternals\n\nAvailable trace flags:\n\n");
        for (VmTraceFlag flag : VmTraceFlag.getFlags()) {
            sb.append(String.format("-Xtrace%s (%d)\n", flag.getName(), flag.getNumber()));
        }
        sb.append("\nPass an empty flags parameter to clear the trace flags.\n");
        return sb.toString();
    }

    private int parseFlag(String flag) {
        int flagNum;
        block4: {
            String f = flag.toLowerCase();
            if (f.startsWith("-xtrace")) {
                f = f.substring(7);
            }
            flagNum = 0;
            try {
                flagNum = Integer.parseInt(f);
            }
            catch (NumberFormatException e) {
                VmTraceFlag vmtf = VmTraceFlag.getFlagByName((String)f);
                if (vmtf == null) break block4;
                flagNum = vmtf.getNumber();
            }
        }
        if (flagNum < -2 || flagNum == 0) {
            throw new IllegalArgumentException("flag '" + flag + "' is no supported SAP JVM trace flag");
        }
        return flagNum;
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        Object[] flags;
        ArrayList<Integer> flagList = new ArrayList<Integer>();
        String flagStr = this.flagsArg.getValue();
        if (flagStr.length() > 0) {
            for (String string : flags = flagStr.split("\\s")) {
                int flagNum = this.parseFlag(string);
                if (flagNum < 0) {
                    throw new IllegalArgumentException("flag '" + string + "' is no supported SAP JVM trace flag");
                }
                flagList.add(flagNum);
            }
        } else if (args.length == 0 && this.jvmMon.getInput() != null) {
            for (VmTraceFlag flag : VmTraceFlag.getFlags()) {
                System.out.format("-Xtrace%s (%d)\n", flag.getName(), flag.getNumber());
            }
            System.out.println();
            System.out.println("All previously enabled flags will be cleared!");
            System.out.println();
            int flagNum = -1;
            while (true) {
                System.out.print("Add flag (-1 to finish, -2 to cancel): ");
                flagNum = this.parseFlag(this.jvmMon.getInput().readLine());
                if (flagNum == -2) {
                    System.out.println("Cancelled.");
                    return true;
                }
                if (flagNum == -1) break;
                flagList.add(flagNum);
            }
        }
        flags = flagList.stream().mapToInt(Integer::intValue).toArray();
        for (String string : vms) {
            string.setTraceFlags((int[])flags);
        }
        return true;
    }
}

