/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;

public class StartDebuggingCommand
extends Command {
    private final CommandStringArgument localArg;
    private final CommandStringArgument suspendArg;

    public StartDebuggingCommand(JvmMonConsole jvmMon) {
        super(jvmMon, Command.CommandType.VM_MISC_OPERATION);
        this.localArg = this.cmdArgs.addStringArgument("local", true, "false");
        this.suspendArg = this.cmdArgs.addStringArgument("suspend", true, "false");
    }

    @Override
    public String getOpcode() {
        return "start debugging";
    }

    @Override
    public String getSyntax() {
        return this.getOpcode() + " [local=<true|false>] [suspend=<true|false>]";
    }

    @Override
    public String getHelpText() {
        return "Starts on-the-fly debugging";
    }

    @Override
    public String getDetailedHelpText() {
        return this.getHelpText() + ".\n\nThe debugging port range can be set using the \"set debugging port range\" command.\nThe default port range is [8000-8080].\n";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        boolean local = Boolean.parseBoolean(this.localArg.getValue());
        boolean suspend = Boolean.parseBoolean(this.suspendArg.getValue());
        for (MonitoredVm vm : vms) {
            vm.openDebugPort(suspend, local);
        }
        return true;
    }
}

