/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command;

import com.sap.jvm.inspector.jvmmon.MonitoredVm;
import com.sap.jvm.tools.monitor.jvmmon.JvmMonConsole;
import com.sap.jvm.tools.monitor.jvmmon.command.Command;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandIntegerArgument;
import java.io.IOException;

public class SymbolInformationCommand
extends Command {
    private CommandIntegerArgument maxNumberArg;

    public SymbolInformationCommand(JvmMonConsole jvmMon, boolean localOutput) {
        super(jvmMon, localOutput ? Command.CommandType.VM_PRINT_OPERATION : Command.CommandType.VM_DUMP_OPERATION, localOutput);
        this.maxNumberArg = this.cmdArgs.addIntegerArgument("num", true, 10);
    }

    @Override
    public String getOpcode() {
        return (this.localOutput() ? "print" : "dump") + " symbol info";
    }

    @Override
    public String getSyntax() {
        return this.localOutput() ? this.getOpcode() + " [num=<maxNumberSymbols>]" : this.getOpcode();
    }

    @Override
    public String getHelpText() {
        return (this.localOutput() ? "Prints" : "Dumps") + " information about symbols and interned strings of a VM";
    }

    @Override
    protected boolean executeInternal(String[] args, MonitoredVm[] vms) throws IOException {
        int num = this.maxNumberArg.getValue();
        for (MonitoredVm vm : vms) {
            if (vms.length > 1) {
                this.printVMHeader(vm);
            }
            this.printLegacyMonitoringOperationResult(vm.getSymbolInfo(!this.localOutput(), num));
        }
        return true;
    }
}

