/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command.argument;

abstract class CommandArgument {
    private final String key;
    private final boolean isOptional;
    private boolean isParsed;

    protected CommandArgument(String key, boolean isOptional) {
        this.key = key;
        this.isOptional = isOptional;
        this.isParsed = false;
        if (isOptional) {
            this.setToDefault();
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    protected void setParsed() {
        this.isParsed = true;
    }

    public void reset() {
        this.setToDefault();
        this.isParsed = false;
    }

    protected String getValueString(String keyValueStr) {
        String valueStr = null;
        if (keyValueStr.startsWith(this.key) && keyValueStr.length() > this.key.length()) {
            if (keyValueStr.charAt(this.key.length()) != '=') {
                throw new IllegalArgumentException("wrong argument syntax '" + keyValueStr + "'. Missing '=' after " + this.key);
            }
            valueStr = keyValueStr.substring(this.key.length() + 1);
        }
        return valueStr;
    }

    protected abstract void setValue(String var1);

    protected abstract void setToDefault();
}

