/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.command.argument;

import com.sap.jvm.tools.console.ConsoleReader;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandArgument;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandIntegerArgument;
import com.sap.jvm.tools.monitor.jvmmon.command.argument.CommandStringArgument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CommandArguments {
    private List<CommandArgument> commandArgs = new ArrayList<CommandArgument>();
    private CommandArgument mainArgument = null;

    public CommandIntegerArgument addIntegerArgument(String key, boolean optional, int defaultValue) {
        CommandIntegerArgument result = new CommandIntegerArgument(key, optional, defaultValue);
        this.addArgument(result);
        return result;
    }

    public CommandStringArgument addStringArgument(String key, boolean optional, String defaultValue) {
        CommandStringArgument result = new CommandStringArgument(key, optional, defaultValue);
        this.addArgument(result);
        return result;
    }

    private void addArgument(CommandArgument arg) {
        if (this.commandArgs.size() == 0) {
            this.mainArgument = arg;
        } else if (this.mainArgument != null && this.mainArgument.isOptional() && !arg.isOptional()) {
            this.mainArgument = arg;
        } else if (this.mainArgument == null || this.mainArgument.isOptional() || !arg.isOptional()) {
            this.mainArgument = null;
        }
        this.commandArgs.add(arg);
    }

    public void parse(String[] args, ConsoleReader reader) throws IllegalArgumentException {
        if (this.commandArgs.size() <= 0) {
            return;
        }
        for (CommandArgument arg : this.commandArgs) {
            arg.reset();
        }
        ArrayList<String> notMatched = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String argValStr = args[i];
            boolean matched = false;
            for (CommandArgument arg : this.commandArgs) {
                String valStr = arg.getValueString(argValStr);
                if (valStr == null) continue;
                if (valStr.length() > 0) {
                    arg.setValue(valStr);
                }
                arg.setParsed();
                matched = true;
                break;
            }
            if (matched) continue;
            notMatched.add(argValStr);
        }
        if (notMatched.size() == 1 && this.mainArgument != null && !this.mainArgument.isParsed()) {
            String valToMatch = (String)notMatched.get(0);
            try {
                this.mainArgument.setValue(valToMatch);
                this.mainArgument.setParsed();
                notMatched.clear();
            }
            catch (IllegalArgumentException argValStr) {
                // empty catch block
            }
        }
        if (notMatched.size() > 0) {
            throw new IllegalArgumentException("unknown argument " + (String)notMatched.get(0));
        }
        for (CommandArgument arg : this.commandArgs) {
            if (arg.isOptional() || arg.isParsed()) continue;
            if (reader != null) {
                System.out.print(arg.getKey() + " = ");
                try {
                    arg.setValue(reader.readLine());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("non optional argument '" + arg.getKey() + "' is missing");
        }
    }
}

