/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tools.monitor.jvmmon.gui;

import com.sap.jvm.inspector.jvmmon.MonitoringController;
import com.sap.jvm.inspector.jvmmon.PasswordSupplier;
import com.sap.jvm.tools.monitor.jvmmon.JvmMon;
import com.sap.jvm.tools.monitor.jvmmon.Resources;
import com.sap.jvm.tools.monitor.jvmmon.gui.PasswordDialog;
import com.sap.jvm.tracing.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class AddClusterDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 2027603424354134914L;
    private static AddClusterDialog dialog;
    private JTextField hostnameField;
    private JTextField portField;
    private List<MonitoringController> connectionList = new ArrayList<MonitoringController>();

    public static void showDialog(JFrame frame, String title, List<MonitoringController> connectionList) {
        dialog = new AddClusterDialog(frame, title, connectionList);
        dialog.setVisible(true);
    }

    private AddClusterDialog(JFrame frame, String title, List<MonitoringController> connectionList) {
        super(frame, title, true);
        this.connectionList = connectionList;
        JPanel connectPanel = new JPanel(new GridBagLayout());
        TitledBorder titleBorder = BorderFactory.createTitledBorder(Resources.getText("Cluster", new Object[0]));
        titleBorder.setTitleJustification(1);
        connectPanel.setBorder(titleBorder);
        this.createConnectContent(connectPanel);
        JButton okButton = new JButton(Resources.getText("Ok", new Object[0]));
        okButton.addActionListener(this);
        okButton.setActionCommand("Ok");
        JButton cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(okButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        mainPanel.add((Component)connectPanel, "Center");
        mainPanel.add((Component)buttonPanel, "Last");
        Container contentPane = this.getContentPane();
        contentPane.add((Component)mainPanel, "Center");
        this.setLocationRelativeTo(frame);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("Cancel".equals(e.getActionCommand())) {
            dialog.setVisible(false);
        } else if ("Ok".equals(e.getActionCommand())) {
            String host = this.hostnameField.getText();
            int port = 1099;
            try {
                port = Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            dialog.setVisible(false);
            try {
                MonitoringController toAdd = new MonitoringController(host, port, new PasswordSupplier(){

                    public String get() throws IOException {
                        PasswordDialog.showDialog(null, Resources.getText("Password required", new Object[0]));
                        return PasswordDialog.getPassword();
                    }
                }, !JvmMon.isNew());
                if (toAdd.isConnected()) {
                    this.connectionList.add(toAdd);
                } else {
                    JOptionPane.showMessageDialog(null, Resources.getText("No connection can be established. Is the jvmmond tool running on the remote host?", new Object[0]), Resources.getText("Connection error", new Object[0]), 2);
                }
            }
            catch (IOException e1) {
                Trace.get(this.getClass()).error((Throwable)e1, "Caught exception, should not happen here.");
                JOptionPane.showMessageDialog(null, Resources.getText("No connection can be established. Is the jvmmond tool running on the remote host?", new Object[0]), Resources.getText("Connection error", new Object[0]), 2);
            }
        }
    }

    private void createConnectContent(JPanel connectPanel) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        JLabel hostnameLabel = new JLabel(Resources.getText("Host:", new Object[0]));
        this.hostnameField = new JTextField();
        this.hostnameField.setColumns(20);
        this.hostnameField.setEnabled(true);
        this.hostnameField.setEditable(true);
        c.gridy = 0;
        c.gridx = 0;
        connectPanel.add((Component)hostnameLabel, c);
        c.gridy = 0;
        c.gridx = 1;
        connectPanel.add((Component)this.hostnameField, c);
        JLabel portLabel = new JLabel(Resources.getText("Port:", new Object[0]));
        this.portField = new JTextField();
        this.portField.setText("1099");
        this.portField.setColumns(20);
        this.portField.setEnabled(true);
        this.portField.setEditable(true);
        c.gridy = 1;
        c.gridx = 0;
        connectPanel.add((Component)portLabel, c);
        c.gridy = 1;
        c.gridx = 1;
        connectPanel.add((Component)this.portField, c);
    }
}

